#include "testshell.h"
#include "ui_testshell.h"
#include <qio_devices.hpp>

TestShell::TestShell(QWidget *parent) :
    QDialog(parent)
    , ui_console()
    , ui(new Ui::TestShell)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);

    ui_console.setParent(this);
    ui->verticalLayout->insertWidget(0, &ui_console);
    ui->temp_widget->hide();

    auto io = new QConsoleIODevice();
    //connect(&ui_console, SIGNAL(Console::getData), &io_console, SLOT(ConsoleIODevice::on_input) );
    connect(&ui_console, &Console::getData, io, &QConsoleIODevice::on_input );
    connect(io, &QConsoleIODevice::signal_output, &ui_console, &Console::putData );
    io_console = io;

    ui_console.setEnabled(true);

    _shell = QShell::newShell( io_console, "testshell" );
    connect(_shell, &QShell::finished, this, &TestShell::on_buttonBox_accepted );
    shell().take_own( std::move(*io) );
    shell().start();
}

TestShell::~TestShell()
{
    delete ui;
    _shell->terminate();
}

void TestShell::on_input(const QByteArray data){
    io_console->on_input(data);
}

void TestShell::on_buttonBox_accepted()
{
    _shell->terminate();
    close();
}

void TestShell::on_buttonBox_rejected()
{
    _shell->terminate();
    close();
}
