/*
 * max6954demo.c
 *
 * utf8 ru
  *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 *------------------------------------------------------
 *     LCD max6954
 *      1 ,
 *        
 *           -
 *      digX+digXA
 *  :
 *  -   
 *  -   ,  ,  
 *  -   - /   
 *  -   -  
 *  -  GPIO
 *  -   GPIO
 */

#include "max6954demo.h"
#include <dev/max6954.h>
//provide MAX6954_xxx
#include <hw.h>
#include <sys/pt.h>


MAX6954h max6954h;
//      
struct pt       max6954pt;

PT_THREAD(max6954_demo(struct pt* self));

void max6954_demo_init(void){
    MAX6954_init(&max6954h, MAX6954_SPI
                 , MAX6954_nCS_GPIO_Port, MAX6954_nCS_Pin
                 );
    MAX6954_blink_assign(&max6954h, MAX6954_BLINK_TIM);
    PT_INIT(&max6954pt);
}

//    max6954
void max6954_demo_process(void){
    max6954_demo(&max6954pt);
}


MAX6954_IntensitySet    max6954_colors;
MAX6954_IntensitySet* assign_color( MAX6954_IntensityValue c );
MAX6954_IntensitySet* up_color();
MAX6954_IntensitySet* dn_color();

PT_THREAD(max6954_demo(struct pt* self)){
    const MAX6954_IntensityValue RED_COLOR  = MAX6954_BiColorVal( MAX6954_ivLIM, 0);
    const MAX6954_IntensityValue GRN_COLOR  = MAX6954_BiColorVal( 0, MAX6954_ivLIM);
    const MAX6954_IntensityValue YELOW_COLOR = MAX6954_BiColorVal( MAX6954_ivLIM/2, MAX6954_ivLIM/2);
    unsigned long       keys;
    MAX6954_PortState   pins;
    static unsigned     blink_rate;

    PT_BEGIN(self);
    MAX6954_reset(&max6954h);
    MAX6954_set_digit_type_all_7segment(&max6954h
                    ,  MAX6954_ALL_DIGITS
                      |MAX6954_LEN_7SEG_BICOLORA
                      );
    MAX6954_port_set_mode(&max6954h
                        , MAX6954_KEYBOARD_LINES
                        , MAX6954_PINS
                        );

    while (true){
        MAX6954_begin(&max6954h); //   
        MAX6954_write_string(&max6954h, "01234567890abcdef");
        //   
        PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );

        MAX6954_write_int(&max6954h, 0xa5a5a5a5);
        //   
        PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );

        MAX6954_write_float(&max6954h, 3.14);
        //   
        PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );


        //  .
        MAX6954_enable_individual_segment_brightness(&max6954h);
        MAX6954_control_intensity(&max6954h, assign_color(YELOW_COLOR));
        while (true) {
            //   
            PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );
            keys = MAX6954_keys_1line(&max6954h);
            if (keys& MAX6954_KEY_ENTER)
                break;
            else
            if (keys& MAX6954_KEY_UP){
                MAX6954_control_intensity(&max6954h, assign_color(RED_COLOR));
                continue;
            }
            else
            if (keys& MAX6954_KEY_DN){
                MAX6954_control_intensity(&max6954h, assign_color(GRN_COLOR));
                continue;
            }
            else
            if (keys& MAX6954_KEY_LF){
                MAX6954_control_intensity(&max6954h, up_color());
                continue;
            }
            else
            if (keys& MAX6954_KEY_RT){
                MAX6954_control_intensity(&max6954h, dn_color());
                continue;
            }
        }
        MAX6954_enable_global_segment_brightness(&max6954h);

        //demo  
        MAX6954_blink_enable(&max6954h);
        blink_rate = 10;
        while (true) {
            //   
            PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );
            keys = MAX6954_keys_1line(&max6954h);
            if (keys& MAX6954_KEY_ENTER)
                break;
            else
            if (keys& MAX6954_KEY_UP){
                if (blink_rate < 40)
                    blink_rate++;
                MAX6954_blink_rate_01s(&max6954h, blink_rate);
                continue;
            }
            else
            if (keys& MAX6954_KEY_DN){
                if (blink_rate > 2)
                    blink_rate--;
                MAX6954_blink_rate_01s(&max6954h, blink_rate);
                continue;
            }
        }
        MAX6954_blink_disable(&max6954h);

        // GPIO
        MAX6954_gpio_set(&max6954h, MAX6954_LED_RED);
        PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );

        MAX6954_gpio_set(&max6954h, MAX6954_ALARM);
        PT_WAIT_UNTIL(self, MAX6954_check_keys(&max6954h) );

        //   MAX6954_IN_LOCK,     
        //  MAX6954_IN_LOCK   / 
        while (true){
            if (MAX6954_check_keys(&max6954h))
                break;
            {
                unsigned now = MAX6954_gpio(&max6954h);
                if (pins != now) {
                    pins = now;
                    if (pins & MAX6954_IN_LOCK)
                        MAX6954_enable_individual_segment_brightness(&max6954h);
                    else
                        MAX6954_enable_global_segment_brightness(&max6954h);
                }
            }

            PT_YIELD(self);
        }

    }//while

    PT_END(self);
}

MAX6954_IntensitySet* assign_color( MAX6954_IntensityValue c ){
    for (int i = 0; i < sizeof(max6954_colors.seg);)
        max6954_colors.seg[i] = c;
    return &max6954_colors;
}

MAX6954_IntensitySet* up_color(){
    MAX6954_IntensityValue tmp = max6954_colors.seg[0];
    unsigned c1 = tmp & MAX6954_ivLIM;
    unsigned c2 = (tmp >> 4) & MAX6954_ivLIM;
    ++c1; ++c2;
    return assign_color( MAX6954_BiColorVal(c1,c2) );
}

MAX6954_IntensitySet* dn_color(){
    MAX6954_IntensityValue tmp = max6954_colors.seg[0];
    unsigned c1 = tmp & MAX6954_ivLIM;
    unsigned c2 = (tmp >> 4) & MAX6954_ivLIM;
    --c1; --c2;
    return assign_color( MAX6954_BiColorVal(c1,c2) );
}
