/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef HAL_MDR32F9QX_MCU_USART_H_
#define HAL_MDR32F9QX_MCU_USART_H_

#include <stdint.h>

#include "../../HALMCU/STM32.LL/mcu-chip.h"

// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_usart.h>
#elif defined(STM32H7)
#include <stm32f7xx_hal_usart.h>
#else
#warning "uncknown STM32 HAL"
#endif

#include <c_compat.h>

#ifdef __cplusplus
extern "C" {
#endif


#if defined(STM32H7)   //__STM32F7xx_HAL_CONF_H
#define UART_HWCONTROL_DE   (USART_CR3_DEM)
#define UART_HWCONTROL_nDE  (USART_CR3_DEM | USART_CR3_DEP)
#endif

#define USART_IT_TXE        LL_USART_CR1_TXEIE

__STATIC_INLINE
void USART_ITConfig(USART_TypeDef* USARTx, unsigned IT, bool onoff) {
    if (onoff)
        SET_BIT(USARTx->CR1, IT);
    else
        CLEAR_BIT(USARTx->CR1, IT);
}

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
