/*
 * mcu_rcc.h
 *
 *  Created on: 22/04/2021 г.
 *      Author: alexraynepe196@gmail.com
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
   -----------------------------------------------------------------------
    this is renesas CGC API wrapper to STM RCC-like API
 */

#ifndef BSP_CPU_MCU_RCC_H_
#define BSP_CPU_MCU_RCC_H_

#include <mcu-chip.h>

#include "bsp_api.h"


#if 1
// this startup frequencies not change by APP
#define BSP_CLK_STATIC          1

/* Startup clock frequency of each system clock. These macros are only helpful if the system clock and dividers have
 * not changed since startup. These macros are not used in FSP modules except for the clock startup code. */
#define BSP_ICLK_HZ             BSP_STARTUP_ICLK_HZ
#define BSP_PCLKA_HZ            BSP_STARTUP_PCLKA_HZ
#define BSP_PCLKB_HZ            BSP_STARTUP_PCLKB_HZ
#define BSP_PCLKC_HZ            BSP_STARTUP_PCLKC_HZ
#define BSP_PCLKD_HZ            BSP_STARTUP_PCLKD_HZ
#define BSP_BCLK_HZ             BSP_STARTUP_BCLK_HZ
#define BSP_FCLK_HZ             BSP_STARTUP_FCLK_HZ

#elif 0
// there frequencies only source clock by APP, but PCLKx divs a keep origin
#define BSP_CLK_STATIC         0

#define BSP_ICLK_HZ                    (SystemCoreClock)
#define BSP_SOURCE_CLOCK_HZ            (SystemCoreClock << BSP_CFG_ICLK_DIV)
#define BSP_PCLKA_HZ                   (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_PCLKA_DIV)
#define BSP_PCLKB_HZ                   (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_PCLKB_DIV)
#define BSP_PCLKC_HZ                   (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_PCLKC_DIV)
#define BSP_PCLKD_HZ                   (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_PCLKD_DIV)
#define BSP_BCLK_HZ                    (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_BCLK_DIV)
#define BSP_FCLK_HZ                    (BSP_SOURCE_CLOCK_HZ >> BSP_CFG_FCLK_DIV)

#else
// there app changes frequencyes free
#define BSP_CLK_STATIC         0

#define BSP_ICLK_HZ                    (SystemCoreClock)
#define BSP_SOURCE_CLOCK_HZ            (SystemCoreClock << R_SYSTEM->SCKDIVCR_b.ICK)
#define BSP_PCLKA_HZ                   (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.PCKA)
#define BSP_PCLKB_HZ                   (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.PCKB)
#define BSP_PCLKC_HZ                   (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.PCKC)
#define BSP_PCLKD_HZ                   (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.PCKD)
#define BSP_BCLK_HZ                    (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.BCK)
#define BSP_FCLK_HZ                    (BSP_SOURCE_CLOCK_HZ >> R_SYSTEM->SCKDIVCR_b.FCK)

#endif


#define RCC_GetTimClockFreq(tim)        BSP_PCLKB_HZ
#define RCC_GetGPTClockFreq(tim)        BSP_PCLKD_HZ
#define RCC_GetUSARTClockFreq(uart)     BSP_PCLKB_HZ

#define FCPU                    BSP_ICLK_HZ



#ifdef __cplusplus
extern "C" {
#endif



void RCC_EnableClock_SPIn( unsigned chanel );
void RCC_DisableClock_SPIn( unsigned chanel );
void RCC_EnableClock_UARTn( unsigned chanel );
void RCC_DisableClock_UARTn( unsigned chanel ) ;


#ifdef __cplusplus
}
#endif



#endif /* BSP_CPU_MCU_RCC_H_ */
