/*
 * mcu_nvic.h
 *
 *  Created on: 13/04/2021
 *      Author: alexraynepe196@gmail.com
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_RA2L_MCU_NVIC_H_
#define HAL_RA2L_MCU_NVIC_H_

#include <mcu-chip.h>

#include <c_compat.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif



#ifndef IS_FUNCTIONAL_STATE
// STM HAL compatibily
typedef enum
{
  DISABLE = 0U,
  ENABLE = !DISABLE
} FunctionalState;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

#endif




/**
  * @brief  NVIC Init Structure definition
  */

typedef struct
{
  int8_t NVIC_IRQChannel;                    /*!< Specifies the IRQ channel to be enabled or disabled.
                                                   This parameter can be an enumerator of @ref IRQn_Type
                                                   enumeration (For the complete STM32 Devices IRQ Channels
                                                   list, please refer to stm32f4xx.h file) */

  uint8_t NVIC_IRQChannelPreemptionPriority;  /*!< Specifies the pre-emption priority for the IRQ channel
                                                   specified in NVIC_IRQChannel. This parameter can be a value
                                                   between 0 and 15 as described in the table @ref MISC_NVIC_Priority_Table
                                                   A lower priority value indicates a higher priority */

  uint8_t NVIC_IRQChannelSubPriority;         /*!< Specifies the subpriority level for the IRQ channel specified
                                                   in NVIC_IRQChannel. This parameter can be a value
                                                   between 0 and 15 as described in the table @ref MISC_NVIC_Priority_Table
                                                   A lower priority value indicates a higher priority */

  /*FunctionalState*/
  uint8_t NVIC_IRQChannelCmd;                 /*!< Specifies whether the IRQ channel defined in NVIC_IRQChannel
                                                   will be enabled or disabled.
                                                   This parameter can be set either to ENABLE or DISABLE */
} NVIC_InitTypeDef;



#define NVIC_DEF( ch, prio, sub, ena ) { \
      struct_field(NVIC_IRQChannel) ch\
    , struct_field(NVIC_IRQChannelPreemptionPriority) prio\
    , struct_field(NVIC_IRQChannelSubPriority)  sub\
    , struct_field(NVIC_IRQChannelCmd)  ena }

#define NVIC_NOIRQ  NVIC_DEF(-3, 0, 0, 0)

void nvic_init( const NVIC_InitTypeDef x );

INLINE
void NVIC_Init(const NVIC_InitTypeDef* x ){ nvic_init(*x); }

INLINE
bool nvic_is_nan( NVIC_InitTypeDef x){
    return (x.NVIC_IRQChannel < 0);
}

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
