/*
 * mcu-chip.h
 *
 *  Created on: 3/12/2020 г.
 *      Author: Lityagin Aleksandr
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 *----------------------------------------------------------------------------
 *  это хедер-порт привязки к проекту.
 *  через этот файл ХАЛ привязывается к чипу проекта.
 *  надо переопередлить его в проекте при смене семейства чипа проекта
 */

#ifndef HAL_RA2L1_MCU_CHIP_H_
#define HAL_RA2L1_MCU_CHIP_H_

#include "bsp_api.h"
//#include "ra/fsp/src/bsp/cmsis/Device/RENESAS/Include/renesas.h"
#include <project-conf.h>


#ifndef RA_H
#error "expects RA series chip"
#endif


#ifdef BOARD_RA2L1_EK
#define R7FA2L1AB2DFP
#endif

#ifdef R7FA2L1AB2DFP
// LQFP 100pin
#define RA2L1xFP
#elif defined( R7FA2L1AB2DFM )
// LQFP 64pin
#define RA2L1xFM
#endif


/// @brief STM LL similar functions
#define SET_BIT(reg, mask)      (reg) |= (mask)
#define CLEAR_BIT(reg, mask)    (reg) &= ~(mask)

#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
}
#endif

#endif /* HAL_STM32_LL_MCU_CHIP_H_ */
