/*
 * dwt.cpp
 *
 *  Created on: 6 мая 2019 г.
 *      Author: Lityagin Aleksandr
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#include <cassert>
#include "mcu-wdt.h"

IWDG_HandleTypeDef     hwdt;

#ifndef WDT_TO_MS
#define WDT_TO_MS   1000
#endif

#ifndef LSI_VALUE
#define LSI_VALUE   32000ul
#endif

#ifdef WDT_PIN

void wdt_reset(hWDT_t* x){
    HAL_IWDG_Refresh(x);
    PIO_Twist(&WDT_PIN);
}

#endif

__WEAK
void wdt_init(void){
    unsigned wdt_to = WDT_TO_MS*LSI_VALUE/256/1000;
    hwdt.Instance = IWDG1;
    hwdt.Init.Prescaler = IWDG_PRESCALER_256;
    hwdt.Init.Reload    = wdt_to;
#ifdef STM32F7
    hwdt.Init.Window    = hwdt.Init.Reload;

#ifdef DEBUG
    // в режиме отладки останавливать вочдог во время останова
    __HAL_DBGMCU_FREEZE_IWDG1();
#endif

#endif // STM32F7

#ifndef WDT_DISABLE
    if ( HAL_IWDG_Init(WDT) != HAL_OK){
        assert(false);
    }
#endif

#ifdef WDT_PIN
    PIO_Configure(WDT_PIN);
#endif
}


#include <stdio.h>
// печать информации о статусе вочдога
void wdt_print(){
    unsigned sr = WDT->Instance->SR;
    unsigned period = WDT->Instance->RLR;
    unsigned prescale = WDT->Instance->PR;
    printf("WDT: CR=$%0x, period=$%0x*$%0x\r\n"
            , sr
            , period
            , prescale
            );
}


//-------------------------------------------------------------------------

#include "watchdog.h"
void watchdog_init(void){
    wdt_init();
};

void watchdog_start(void){
    HAL_IWDG_Init(WDT);
}

void watchdog_periodic(void){
    wdt_reset(WDT);
}
