/*
 * bimsw_device.cpp
 *
 *  Created on: 13 нояб. 2018 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#include <assert.h>
#include "gpiosw_device.hpp"
#include <gpio.h>
#include <mcu_rcc.h>
#include <mcu_gpio.h>

#if 0
#define ASSERT_SW(...)  assert(__VA_ARGS__)
#else
#define ASSERT_SW(...)
#endif

GPIOSwitch_Device::GPIOSwitch_Device(GPIOSwitch_Device::dev_name name)
: inherited(name)
, pins(NULL)
, inverts(0)
{
};

DevResult GPIOSwitch_Device::init(unsigned pinnum, const GPIOSwitch_Device::PIN_INIT* _pins){
    ASSERT_SW(pinnum <= 32);
    if (_pins == NULL)
        pinnum = 0;
    pins = _pins;
    pins_amount = pinnum;
    inverts = 0;
    if (pinnum <= 0)
        return DEV_OK;

    ASSERT_SW(pins != NULL);
    for (unsigned i = 0; i < pinnum; i++){
        const PIN_INIT & pindef = pins[i];
        ASSERT_SW(pindef.port != NULL);
        gpio_conf_out(&pindef);
        if (pindef.style& psINV){
            inverts |= (1 << pindef.pin);
        }
    }
    return init();
}

DevResult GPIOSwitch_Device::init(const PIN_INIT* _pins){
    unsigned ncs = 0;
    if (_pins == NULL){
        return init(NULL, 0);
    }
    for (const PIN_INIT* cs = _pins; cs->port != 0; ncs++, cs++);
    return init(ncs, _pins);
}

//virtual
DevResult GPIOSwitch_Device::pin_set(unsigned id, unsigned state){
    ASSERT_SW(id < pins_amount);
    unsigned pin = (1 << pins[id].pin);
    if ((state != 0) == ((inverts & pin) == 0) )
        gpio_on(pins[id].port, pin);
    else
        gpio_off(pins[id].port, pin);
    return DEV_OK;
}

//virtual
int GPIOSwitch_Device::pin_state(unsigned id) const{
    ASSERT_SW(id < pins_amount);
    unsigned now = gpio_pins(pins[id].port, ~0u);
    unsigned val = (( now^inverts) >> id) & 1;
    return val;
}



