/*
 * mcu_usart.h
 *
 *  Created on: 25 ���. 2018 �.
*      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MCU_SSP_H_
#define HAL_MCU_SSP_H_

#include <MDR32F9Qx_config.h>

#ifdef __cplusplus
extern "C" {
#endif


#include "MDR32F9Qx_ssp.h"

typedef MDR_SSP_TypeDef SSP_TypeDef;
#define SSP1    MDR_SSP1
#define SSP2    MDR_SSP2

#ifdef SSP_CR0_DSS_4_BITS
// так определю наличие библиотеки v1.4.2
#define MDRSPL_SPI142
#else
#define SSP_CR0_DSS_4_BITS      SSP_WordLength4b
#define SSP_CR0_DSS_5_BITS      SSP_WordLength5b
#define SSP_CR0_DSS_6_BITS      SSP_WordLength6b
#define SSP_CR0_DSS_7_BITS      SSP_WordLength7b
#define SSP_CR0_DSS_8_BITS      SSP_WordLength8b
#define SSP_CR0_DSS_9_BITS      SSP_WordLength9b
#define SSP_CR0_DSS_10_BITS      SSP_WordLength10b
#define SSP_CR0_DSS_11_BITS      SSP_WordLength11b
#define SSP_CR0_DSS_12_BITS      SSP_WordLength12b
#define SSP_CR0_DSS_13_BITS      SSP_WordLength13b
#define SSP_CR0_DSS_14_BITS      SSP_WordLength14b
#define SSP_CR0_DSS_15_BITS      SSP_WordLength15b
#define SSP_CR0_DSS_16_BITS      SSP_WordLength16b

#endif

#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
