/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view.edit;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractNavigateFiller implements SelectionListener {

	int currentIdx = 0;

	Table table;

	public AbstractNavigateFiller(Table table) {
		this.table = table;
		table.addSelectionListener(this);
		// currentIdx = table.getItemCount();
	}

	public void widgetSelected(SelectionEvent e) {
		if (!(e.widget instanceof Table)) {
			return;
		}
		currentIdx = table.indexOf((TableItem) e.item);
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/**
	 * filler^[Qbgvaluef[^ꍞ
	 * 
	 * @param value
	 */
	public abstract void acceptString(String value);

	/**
	 * e[uɍsȂꍇAsāAvalue
	 * 
	 * @param value
	 * @return
	 */
	public abstract TableItem addNewLine(String value);

	/**
	 * valuee[u̍sɍ
	 * 
	 * @param item
	 *            ^[Qbgs
	 * @param value
	 *            f[^
	 */
	public abstract void fillStringToTable(TableItem item, String value);

	public void resetIndex() {
		currentIdx = table.getItemCount();
	}
}
