/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.maskat.framework.screendef.ComponentDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.framework.screendef.customize.IContentFactory;
import org.maskat.framework.screendef.customize.IPluginComponentDef;
import org.maskat.ide.gef.models.SplitModel;
import org.maskat.ide.gef.models.TabDef;

public class MaskatEditPartFactory implements EditPartFactory {

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = null;

		if (model instanceof IPluginComponentDef) {
			IContentFactory factory = ((IPluginComponentDef) model).getProxy()
					.getContentFactory();
			if (factory != null) {
				part = factory.newEditPart();
				if (part != null) {
					// contentFactory`Ă΁AfactorydefIuWFNg擾
					part.setModel(model);
					return part;
				}
			}
		}

		if (model instanceof ComponentDef) {
			part = new ComponentEditPart();
		}
		if (model instanceof GridHeaderDef) {
			part = new GridHeaderEditPart();
		}
		if (model instanceof TabFolderDef) {
			part = new TabFolderEditPart();
		}
		if (model instanceof TabItemDef) {
			// ^uy[W
			part = new FolderPageEditPart();
		}
		if (model instanceof TabDef) {
			// ^u{^
			part = new TabEditPart();
		}
		if (model instanceof SplitterDef) {
			// splitter
			part = new SplitterEditPart();
		}
		if (model instanceof DivSplitDef) {
			// divSplit
			part = new SplitPageEditPart();
		}
		if (model instanceof SplitModel) {
			part = new SplitEditPart();
		}
		if (model instanceof TreeViewDef) {
			part = new ComponentEditPart();
		}

		if (part == null) {
			part = new IgnorableEditPart();
		}
		part.setModel(model); // fEditPartɐݒ肷
		return part;
	}
}