/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.List;

public class TreeViewDef extends ComponentDef {
	private String boolSelActive;

	private String withRoot;

	private String rootOpen;

	private String withT;

	private String autoResizableH;

	private String autoResizableW;

	private String draggableNode;

	private String rootNode;

	private List treeNodeList;

	private void addTreeNode(TreeNodeDef treeNode) {
		if (treeNodeList == null)
			treeNodeList = new ArrayList();
		treeNodeList.add(treeNode);
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		if (comp instanceof TreeNodeDef) {
			addTreeNode((TreeNodeDef) comp);
		}
	}

	public List getTreeNodeList() {
		return treeNodeList;
	}

	public void setTreeNodeList(List treeNodeList) {
		this.treeNodeList = treeNodeList;
	}

	public String getAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(String autoResizableH) {
		this.autoResizableH = autoResizableH;
	}

	public String getAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(String autoResizableW) {
		this.autoResizableW = autoResizableW;
	}

	public String getDraggableNode() {
		return draggableNode;
	}

	public void setDraggableNode(String draggableNode) {
		this.draggableNode = draggableNode;
	}

	public String getBoolSelActive() {
		return boolSelActive;
	}

	public void setBoolSelActive(String boolSelActive) {
		this.boolSelActive = boolSelActive;
	}

	public String getRootOpen() {
		return rootOpen;
	}

	public void setRootOpen(String rootOpen) {
		this.rootOpen = rootOpen;
	}

	public String getWithRoot() {
		return withRoot;
	}

	public void setWithRoot(String withRoot) {
		this.withRoot = withRoot;
	}

	public String getWithT() {
		return withT;
	}

	public void setWithT(String withT) {
		this.withT = withT;
	}

	public String getRootNode() {
		return rootNode;
	}

	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

}
