/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import org.maskat.framework.screendef.IComponentDef;

/**
 * Interface for the customized component model object.
 * 
 * @author shengshen
 * 
 */
public interface IPluginComponentDef extends IComponentDef {
	/**
	 * Get the proxy class for the customized component model object.
	 * 
	 * @return
	 */
	public PluginDefProxy getProxy();

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getAttribute(String key);

	/**
	 * 
	 * @param key
	 * @param value
	 */
	public void setAttribute(String key, String value);
}
