/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.maskat.ide.gef.editparts.ComponentEditPart;

public class CodeLibFigure extends Label {
	static final Image CODELIBBUTTON = createImage("/images/codelibbutton.gif");

	private boolean withLabelInput;

	private static Image createImage(String name) {
		InputStream stream = ComponentEditPart.class.getResourceAsStream(name);
		Image image = new Image(null, stream);
		try {
			stream.close();
		} catch (IOException ioe) {
		}
		return image;
	}

	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		graphics.drawRectangle(3, 3, 30, 14);
		graphics.drawImage(CODELIBBUTTON, 37, 2);
		if (withLabelInput) {
			graphics.drawRectangle(60, 3, bounds.width - 65, 14);
		}
		graphics.translate(-bounds.x, -bounds.y);
	}

	public boolean isWithLabelInput() {
		return withLabelInput;
	}

	public void setWithLabelInput(boolean withLabelInput) {
		this.withLabelInput = withLabelInput;
	}
}
