/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfo
extends FieldInfo {
    public static final String REFERENCE_SUFFIX_PROPERTY = "org.exolab.castor.builder.collections.reference.suffix";
    public static final String DEFAULT_REFERENCE_SUFFIX = "AsReference";
    protected XSList xsList = (XSList)this.getSchemaType();
    private String contentName = null;
    private XSType contentType = null;
    private FieldInfo content = null;
    private String elementName;
    private boolean _extraMethods = false;
    private String _referenceSuffix = "AsReference";

    public CollectionInfo(XSType contentType, String name, String elementName) {
        super(new XSList(contentType), name);
        this.contentType = contentType;
        if (elementName.charAt(0) == '_') {
            elementName = elementName.substring(1);
        }
        this.contentName = "v" + JavaNaming.toJavaClassName(elementName);
        this.elementName = elementName;
        this.content = new FieldInfo(contentType, this.contentName);
    }

    public void generateInitializerCode(JSourceCode jsc) {
        jsc.add(this.getName());
        jsc.append(" = new Vector();");
    }

    public String getReadMethodName() {
        StringBuffer sb = new StringBuffer("get");
        sb.append(JavaNaming.toJavaClassName(this.getElementName()));
        return sb.toString();
    }

    public String getWriteMethodName() {
        StringBuffer sb = new StringBuffer();
        sb.append("add");
        sb.append(JavaNaming.toJavaClassName(this.getElementName()));
        return sb.toString();
    }

    public void createAccessMethods(JClass jClass) {
        JMethod method = null;
        JParameter contentParam = new JParameter(this.getContentType().getJType(), this.getContentName());
        Object jsc = null;
        String cName = JavaNaming.toJavaClassName(this.getElementName());
        method = new JMethod(null, "add" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(contentParam);
        this.createAddMethod(method);
        method = new JMethod(null, "add" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        method.addParameter(contentParam);
        this.createAddInsertMethod(method);
        JType jType = this.getContentType().getJType();
        method = new JMethod(jType, "get" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        this.createGetByIndexMethod(method);
        jType = jType.createArray();
        method = new JMethod(jType, "get" + cName);
        jClass.addMethod(method);
        this.createGetMethod(method);
        if (this.extraMethods()) {
            method = new JMethod(SGTypes.Vector, "get" + cName + this._referenceSuffix);
            jClass.addMethod(method);
            this.createGetCollectionReferenceMethod(method);
        }
        method = new JMethod(null, "set" + cName);
        jClass.addMethod(method);
        method.addException(SGTypes.IndexOutOfBoundsException);
        method.addParameter(new JParameter(JType.Int, "index"));
        method.addParameter(contentParam);
        this.createSetByIndexMethod(method);
        JType arrayType = contentParam.getType().createArray();
        String pName = JavaNaming.toJavaMemberName(cName);
        JParameter arrayParam = new JParameter(arrayType, pName + "Array");
        method = new JMethod(null, "set" + cName);
        method.addParameter(arrayParam);
        jClass.addMethod(method);
        this.createSetArrayMethod(method);
        if (this.extraMethods()) {
            JParameter vParam = new JParameter(SGTypes.Vector, pName + "Vector");
            method = new JMethod(null, "set" + cName);
            method.addParameter(vParam);
            jClass.addMethod(method);
            this.createSetCollectionMethod(method);
            method = new JMethod(null, "set" + cName + this._referenceSuffix);
            method.addParameter(vParam);
            jClass.addMethod(method);
            this.createSetCollectionReferenceMethod(method);
        }
        method = new JMethod(JType.Int, "get" + cName + "Count");
        jClass.addMethod(method);
        this.createGetCountMethod(method);
        method = new JMethod(SGTypes.Enumeration, "enumerate" + cName);
        jClass.addMethod(method);
        this.createEnumerateMethod(method);
        jType = this.getContentType().getJType();
        method = new JMethod(jType, "remove" + cName);
        jClass.addMethod(method);
        method.addParameter(new JParameter(JType.Int, "index"));
        this.createRemoveByIndexMethod(method);
        method = new JMethod(null, "removeAll" + cName);
        jClass.addMethod(method);
        this.createRemoveAllMethod(method);
    }

    public JMethod getReadMethod() {
        String methodName = this.getReadMethodName();
        JType jType = this.getContentType().getJType();
        JMethod jMethod = new JMethod(jType, methodName);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("return this.");
        jsc.append(this.getName());
        jsc.append(";");
        return jMethod;
    }

    public XSList getXSList() {
        return this.xsList;
    }

    public String getContentName() {
        return this.contentName;
    }

    public XSType getContentType() {
        return this.contentType;
    }

    public FieldInfo getContent() {
        return this.content;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isMultivalued() {
        return true;
    }

    public void createAddMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException(\"");
            jsc.append(method.getName());
            jsc.append(" has a maximum of ");
            jsc.append(Integer.toString(maxSize));
            jsc.append("\");");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".addElement(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createAddInsertMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append(this.getName());
            jsc.append(".size() < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException(\"");
            jsc.append(method.getName());
            jsc.append(" has a maximum of ");
            jsc.append(Integer.toString(maxSize));
            jsc.append("\");");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".insertElementAt(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(", index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createGetMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("int size = ");
        jsc.append(this.getName());
        jsc.append(".size();");
        String variableName = this.getName() + ".elementAt(index)";
        JType compType = jType.getComponentType();
        jsc.add(compType.toString());
        jsc.append("[] mArray = new ");
        if (compType.isArray()) {
            jsc.append(compType.getComponentType().toString());
        } else {
            jsc.append(compType.toString());
        }
        jsc.append("[size]");
        if (compType.isArray()) {
            jsc.append("[]");
        }
        jsc.append(";");
        jsc.add("for (int index = 0; index < size; index++) {");
        jsc.indent();
        jsc.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return mArray;");
    }

    public void createGetCollectionReferenceMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Returns a reference to '");
        comment.appendComment(cName);
        comment.appendComment("'.");
        comment.appendComment(" No type checking is performed on any ");
        comment.appendComment("modications to the Vector.");
        JDocDescriptor jDesc = JDocDescriptor.createReturnDesc();
        jDesc.setDescription("returns a reference to the Vector.");
        comment.addDescriptor(jDesc);
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return ");
        jsc.append(this.getName() + ';');
    }

    public void createGetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index >= ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException(\"");
        jsc.append(method.getName());
        jsc.append(": Index value '\"+index+\"' not in range [0..\"+(");
        jsc.append(this.getName());
        jsc.append(".size() - 1) + \"]");
        jsc.append("\");");
        jsc.unindent();
        jsc.add("}");
        jsc.add("");
        jsc.add("return ");
        String variableName = this.getName() + ".elementAt(index)";
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.toString());
            jsc.append(") ");
            jsc.append(variableName);
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode(variableName));
        }
        jsc.append(";");
    }

    public void createSetArrayMethod(JMethod method) {
        String index;
        JSourceCode jsc = method.getSourceCode();
        String paramName = method.getParameter(0).getName();
        if (paramName.equals(index = "i")) {
            index = "j";
        }
        jsc.add("//-- copy array");
        jsc.add(this.getName());
        jsc.append(".removeAllElements();");
        jsc.add("for (int ");
        jsc.append(index);
        jsc.append(" = 0; ");
        jsc.append(index);
        jsc.append(" < ");
        jsc.append(paramName);
        jsc.append(".length; ");
        jsc.append(index);
        jsc.append("++) {");
        jsc.indent();
        jsc.add(this.getName());
        jsc.append(".addElement(");
        jsc.append(this.getContentType().createToJavaObjectCode(paramName + '[' + index + ']'));
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("//-- check bounds for index");
        jsc.add("if ((index < 0) || (index >= ");
        jsc.append(this.getName());
        jsc.append(".size())) {");
        jsc.indent();
        jsc.add("throw new IndexOutOfBoundsException(\"");
        jsc.append(method.getName());
        jsc.append(": Index value '\"+index+\"' not in range [0..\" + (");
        jsc.append(this.getName());
        jsc.append(".size() - 1) + \"]");
        jsc.append("\");");
        jsc.unindent();
        jsc.add("}");
        int maxSize = this.getXSList().getMaximumSize();
        if (maxSize > 0) {
            jsc.add("if (!(");
            jsc.append("index < ");
            jsc.append(Integer.toString(maxSize));
            jsc.append(")) {");
            jsc.indent();
            jsc.add("throw new IndexOutOfBoundsException(\"");
            jsc.append(method.getName());
            jsc.append(" has a maximum of ");
            jsc.append(Integer.toString(maxSize));
            jsc.append("\");");
            jsc.unindent();
            jsc.add("}");
        }
        jsc.add(this.getName());
        jsc.append(".setElementAt(");
        jsc.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jsc.append(", index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetCollectionMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        String paramName = method.getParameter(0).getName();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(cName);
        comment.appendComment("' by copying the given Vector.");
        JDocDescriptor jDesc = comment.getParamDescriptor(paramName);
        jDesc.setDescription("the Vector to copy.");
        JSourceCode jsc = method.getSourceCode();
        String index = "i";
        if (paramName.equals(index)) {
            index = "j";
        }
        jsc.add("//-- copy vector");
        jsc.add(this.getName());
        jsc.append(".removeAllElements();");
        jsc.add("for (int ");
        jsc.append(index);
        jsc.append(" = 0; ");
        jsc.append(index);
        jsc.append(" < ");
        jsc.append(paramName);
        jsc.append(".size(); ");
        jsc.append(index);
        jsc.append("++) {");
        jsc.indent();
        jsc.add(this.getName());
        jsc.append(".addElement(");
        jsc.append('(' + this.getContentType().getJType().toString() + ')');
        jsc.append(this.getContentType().createToJavaObjectCode(paramName + ".elementAt(" + index + ')'));
        jsc.append(");");
        jsc.unindent();
        jsc.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void createSetCollectionReferenceMethod(JMethod method) {
        String cName = JavaNaming.toJavaMemberName(this.getElementName());
        String paramName = method.getParameter(0).getName();
        JDocComment comment = method.getJDocComment();
        comment.appendComment("Sets the value of '");
        comment.appendComment(cName);
        comment.appendComment("' by setting it to the given Vector.");
        comment.appendComment(" No type checking is performed.");
        JDocDescriptor jDesc = comment.getParamDescriptor(paramName);
        jDesc.setDescription("the Vector to copy.");
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(" = ");
        jsc.append(paramName + ';');
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this._extraMethods = extraMethods;
    }

    public void setReferenceMethodSuffix(String suffix) {
        this._referenceSuffix = suffix == null || suffix.length() == 0 ? DEFAULT_REFERENCE_SUFFIX : suffix;
    }

    protected void createBoundPropertyCode(JSourceCode jsc) {
        jsc.add("notifyPropertyChangeListeners(\"");
        jsc.append(this.getName());
        jsc.append("\", null, ");
        jsc.append(this.getName());
        jsc.append(");");
    }

    public void createGetCountMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return ");
        jsc.append(this.getName());
        jsc.append(".size();");
    }

    public void createEnumerateMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("return ");
        jsc.append(this.getName());
        jsc.append(".elements();");
    }

    public void createRemoveByObjectMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add("boolean removed = ");
        jsc.append(this.getName());
        jsc.append(".removeElement(");
        jsc.append(this.getContentName());
        jsc.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
        jsc.add("return removed;");
    }

    public void createRemoveByIndexMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        JType jType = method.getReturnType();
        jsc.add("java.lang.Object obj = ");
        jsc.append(this.getName());
        jsc.append(".elementAt(index);");
        jsc.add(this.getName());
        jsc.append(".removeElementAt(index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
        jsc.add("return ");
        if (this.getContentType().getType() == 0) {
            jsc.append("(");
            jsc.append(jType.getName());
            jsc.append(") obj;");
        } else {
            jsc.append(this.getContentType().createFromJavaObjectCode("obj"));
            jsc.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod method) {
        JSourceCode jsc = method.getSourceCode();
        jsc.add(this.getName());
        jsc.append(".removeAllElements();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jsc);
        }
    }

    protected final boolean extraMethods() {
        return this._extraMethods;
    }

    protected final String getReferenceMethodSuffix() {
        return this._referenceSuffix;
    }
}

