/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import org.maskat.framework.BasicDef;
import org.maskat.framework.IParentAwareDef;

public class GridHeaderDef extends BasicDef {
	private String width;

	private String title;

	private String type;

	private GridDef parent;

	public int idxInParent() {
		if (parent == null)
			return -1;
		return parent.indexOfHeader(this);
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
		if (parent != null)
			parent.firePropertyChange("gridHeaderTitle", null, "");
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
		if (parent != null)
			parent.firePropertyChange("gridHeaderWidth", null, "");
	}

	public GridDef getParent() {
		return parent;
	}

	public void setParent(GridDef parent) {
		this.parent = parent;
	}

	public void addChild(Object child) {
		if (child instanceof IParentAwareDef) {
			((IParentAwareDef) child).setParentDef(this);
		}
		super.addChild(child);
	}

	public void addChildToIdx(Object child, int idx) {
		if (child instanceof IParentAwareDef) {
			((IParentAwareDef) child).setParentDef(this);
		}
		super.addChildToIdx(child, idx);
	}
}
