/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view.edit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DefaultNavigateFiller extends AbstractNavigateFiller {

	public DefaultNavigateFiller(Table table) {
		super(table);
	}

	public int targetColumn = 0;

	public void acceptString(String value) {
		if (table == null)
			return;
		TableItem item;
		try {
			item = table.getItem(currentIdx);
		} catch (IllegalArgumentException e) {
			// 󔒍sǉ
			item = addNewLine(value);
		}
		fillStringToTable(item, value);
	}

	TableItem addNewLine(String value) {
		TableItem item = new TableItem(table, SWT.NONE);
		return item;
	}

	void fillStringToTable(TableItem item, String value) {
		item.setText(targetColumn, value);
		currentIdx = table.indexOf(item) + 1;
	}
}
