/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.IBasicDef;

/**
 * qvfXgvfɗ^AundoableR}h
 * 
 * @author shengshen
 */
public class SetChildrenCommand extends Command {

	IBasicDef basicDef;

	List oldChildren, newChildren;

	public SetChildrenCommand(IBasicDef basicDef, List children) {
		if (basicDef == null) {
			throw new IllegalArgumentException("parameter [basicDef] is null.");
		}
		this.setLabel("paramύX");
		this.basicDef = basicDef;
		this.newChildren = children;
	}

	public void execute() {
		oldChildren = new ArrayList();
		for (Iterator it = basicDef.getAllChildren(); it != null
				&& it.hasNext();) {
			oldChildren.add(it.next());
		}
		basicDef.removeAllChildren();
		if (newChildren != null) {
			for (Iterator it = newChildren.iterator(); it != null
					&& it.hasNext();) {
				basicDef.addChild(it.next());
			}
		}
	}

	public boolean canUndo() {
		return true;
	}

	public void undo() {
		basicDef.removeAllChildren();
		if (oldChildren != null) {
			for (Iterator it = oldChildren.iterator(); it != null
					&& it.hasNext();) {
				basicDef.addChild(it.next());
			}
		}
	}
}
