/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.List;

import org.maskat.framework.BasicDef;

public class GridLineDef extends BasicDef {
	private List cells;

	public List getCells() {
		return cells;
	}

	public void setCells(List cells) {
		this.cells = cells;
	}

	private void addCell(GridCellDef cell) {
		if (cells == null) {
			cells = new ArrayList();
		}
		cells.add(cell);
	}

	public void addChild(Object comp) {
		super.addChild(comp);
		if (comp instanceof GridCellDef) {
			addCell((GridCellDef) comp);
		}
	}
}