/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.Result;
import org.maskat.ide.property.descriptor.EventPropertyDescriptor;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;
import org.maskat.ide.property.descriptor.SelectPropertyDescriptor;

public class EventProperty extends Event implements IPropertySource, Cloneable {

	private static String PROP_ID = "_prop_id_";

	private static String PROP_TYPE = "_prop_type_";

	private static String PROP_ASYNC = "_prop_async_";

	private static String PROP_START = "_prop_start_";

	private static String PROP_BEFORE = "_prop_before_";

	private static String PROP_AFTER = "_prop_after_";

	private static String PROP_FINISH = "_prop_finish_";

	private static String PROP_PARAM = "_prop_param_";

	private static String PROP_RESULT = "_prop_result_";

	private static String PROP_REMOTEURL = "_prop_remoteurl_";

	// private ParamProperty paramProperty;

	// private ResultProperty resultProperty;

	public EventProperty() {

	}

	public Object getEditableValue() {
		// editableValueƂẮuoffvuonvĂ
		// SetValueCommandundoValueƂẮuoffvuonvł܂B
		return toString();
	}

	private static PropertyDescriptor[] descriptors = new PropertyDescriptor[] {
			new PropertyDescriptor(PROP_ID, "id"),
			new MaskatTextPropertyDescriptor(PROP_TYPE, "type"),
			new MaskatTextPropertyDescriptor(PROP_ASYNC, "async"),
			new MaskatTextPropertyDescriptor(PROP_START, "start"),
			new MaskatTextPropertyDescriptor(PROP_BEFORE, "before"),
			new MaskatTextPropertyDescriptor(PROP_AFTER, "after"),
			new MaskatTextPropertyDescriptor(PROP_FINISH, "finish"),
			new SelectPropertyDescriptor(PROP_PARAM, "param"),
			new SelectPropertyDescriptor(PROP_RESULT, "result"),
			new MaskatTextPropertyDescriptor(PROP_REMOTEURL, "remoteurl") };

	public IPropertyDescriptor[] getPropertyDescriptors() {
		// List headersDesc = new ArrayList();
		// for (Iterator it = this.getAllHeaders(); it != null && it.hasNext();)
		// {
		// Header header = (Header) it.next();
		// headersDesc.add(new PropertyDescriptor(header.getName(), "header"));
		// }
		// if (headersDesc.size() > 0) {
		// List desc = Arrays.asList(descriptors);
		// headersDesc.addAll(desc);
		// return (IPropertyDescriptor[]) headersDesc
		// .toArray(new PropertyDescriptor[0]);
		// }
		if (!enable) {
			return new IPropertyDescriptor[0];
		}
		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(PROP_ID)) {
			return getId();
		}
		if (id.equals(PROP_TYPE)) {
			return getType();
		}
		if (id.equals(PROP_ASYNC)) {
			return getAsync();
		}
		if (id.equals(PROP_START)) {
			return getStart();
		}
		if (PROP_AFTER.equals(id)) {
			return getAfter();
		}
		if (id.equals(PROP_BEFORE)) {
			return getBefore();
		}
		if (id.equals(PROP_FINISH)) {
			return getFinish();
		}
		if (id.equals(PROP_PARAM)) {
			if (getParam() == null) {
				addChild(new ParamProperty());
			}
			return (ParamProperty) getParam();
		}
		if (id.equals(PROP_RESULT)) {
			if (getResult() == null) {
				addChild(new Result());
			}
			return (ResultProperty) getResult();
		}
		if (PROP_REMOTEURL.equals(id)) {
			return getRemoteUrl();
		}
		// Header header = this.findHeader((String) id);
		// if (header != null) {
		// return header;
		// }
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {

	}

	public void setPropertyValue(Object id, Object value) {

		if (id.equals(PROP_ID)) {
			setId((String) value);
		}
		if (id.equals(PROP_TYPE)) {
			setType((String) value);
		}
		if (id.equals(PROP_ASYNC)) {
			setAsync((String) value);
		}
		if (id.equals(PROP_START)) {
			setStart((String) value);
		}
		if (id.equals(PROP_BEFORE)) {
			setBefore((String) value);
		}
		if (PROP_AFTER.equals(id)) {
			setAfter((String) value);
		}
		if (PROP_FINISH.equals(id)) {
			setFinish((String) value);
		}
		if (PROP_REMOTEURL.equals(id)) {
			setRemoteUrl((String) value);
		}
	}

	private boolean enable = true;

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public String toString() {
		if (isEnable())
			return EventPropertyDescriptor.EVENT_ON_DISP;
		return EventPropertyDescriptor.EVENT_OFF_DISP;
	}

}
