/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MaskatProjectPropertyPage extends PropertyPage implements
		IWorkbenchPreferencePage {

	IProject project = null;

	// vWFNgvpeBɂ̃L[ŃXL[}ۑtH_Ă
	public static final QualifiedName SCHEMA_FOLDER_PROPERTY = new QualifiedName(
			"name", "schema_generate_folder");

	Text text = null;

	protected Control createContents(Composite parent) {
		Group prefGroup = new Group(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		prefGroup.setLayout(layout);
		prefGroup.setText("maskat setting");
		GridData data = new GridData(GridData.FILL_BOTH);
		prefGroup.setLayoutData(data);

		Label label = new Label(prefGroup, SWT.NONE);
		label.setText("XL[}tH_F");
		text = new Text(prefGroup, SWT.SINGLE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		text.setLayoutData(data);
		try {
			String value = getProject().getPersistentProperty(
					SCHEMA_FOLDER_PROPERTY);
			text.setText(value == null ? "" : value);
		} catch (CoreException e) {
			ErrorDialog.openError(this.getShell(), "PersistentPropertyǂݍ", // ^Cg
					"PersistentPropertyǂݍݏ̎sɎs܂B", // G[bZ[W
					e.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
		}

		return prefGroup;
	}

	public boolean performOk() {
		try {
			getProject().setPersistentProperty(SCHEMA_FOLDER_PROPERTY,
					text.getText());
		} catch (CoreException e) {
			ErrorDialog.openError(this.getShell(), "PersistentProperty", // ^Cg
					"PersistentPropertyݏ̎sɎs܂B", // G[bZ[W
					e.getStatus());
			MaskatIDEPlugin.getDefault().getLog().log(e.getStatus());
		}
		return true;
	}

	private IProject getProject() {
		if (this.project == null) {
			project = (IProject) (this.getElement().getAdapter(IProject.class));
		}
		return this.project;
	}

	public void init(IWorkbench workbench) {
	}
}
