/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.Iterator;

public class TabFolderDef extends ContainerDef {
	private String widthTabName;

	private String noActiveTab;

	private String autoRedimTab;

	private String draggableItem;

	private String autoResizeParent;

	private String isClosable;

	public int getTabIdxByName(String name) {
		Iterator tabIts = this.getTypedChildren(TabItemDef.class);
		if (tabIts == null)
			return -1;
		int result = 0;
		while (tabIts.hasNext()) {
			if (name.equals(((TabItemDef) tabIts.next()).getName())) {
				return result;
			}
			result++;
		}
		return -1;
	}

	public String getAutoRedimTab() {
		return autoRedimTab;
	}

	public void setAutoRedimTab(String autoRedimTab) {
		this.autoRedimTab = autoRedimTab;
	}

	public String getAutoResizeParent() {
		return autoResizeParent;
	}

	public void setAutoResizeParent(String autoResizeParent) {
		this.autoResizeParent = autoResizeParent;
	}

	public String getDraggableItem() {
		return draggableItem;
	}

	public void setDraggableItem(String draggableItem) {
		this.draggableItem = draggableItem;
	}

	public String getIsClosable() {
		return isClosable;
	}

	public void setIsClosable(String isClosable) {
		this.isClosable = isClosable;
	}

	public String getNoActiveTab() {
		return noActiveTab;
	}

	public void setNoActiveTab(String noActiveTab) {
		this.noActiveTab = noActiveTab;
	}

	public String getWidthTabName() {
		return widthTabName;
	}

	public void setWidthTabName(String widthTabName) {
		firePropertyChange("widthTabName", this.widthTabName, widthTabName);
		this.widthTabName = widthTabName;
	}

}
