/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import org.maskat.framework.BasicDef;

/**
 * Instance of this class corresponds to radioGroup node.<br>
 * This class mainly functions when loading layout definition and writing object
 * to layout definition. Other than than this class should of no use to the IDE.
 * "radioGroup" node which is not a direct child of "layout" node will be deemed as 
 * 
 * @author shengshen
 */
public class RadioGroupDef extends BasicDef {

	private String name;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void addMember(String ref) {
		RadioMemberDef member = new RadioMemberDef();
		member.setRef(ref);
		addChild(member);
	}
}
