/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.maskat.ide.gef.figure.SplitterFigure;
import org.maskat.ide.gef.models.SplitModel;

/**
 * XvbgR|[lg̃muƑΉeditpart
 * 
 * @author shengshen
 * 
 */
public class SplitEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	RectangleFigure figure;

	public void activate() {
		super.activate();
		SplitModel model = (SplitModel) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		SplitModel model = (SplitModel) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	private static Color GRAY_COLOR = new Color(null, 150, 150, 150);

	protected IFigure createFigure() {
		figure = new RectangleFigure();
		figure.setBackgroundColor(GRAY_COLOR);
		figure.addMouseListener(new MouseListener.Stub() {
			public void mousePressed(MouseEvent me) {
				SplitterEditPart splitterEditPart = (SplitterEditPart) SplitEditPart.this
						.getParent();
				splitterEditPart.doSwitch();
				((SplitterFigure) figure.getParent()).showSplitPage(splitterEditPart
						.getCurrentSelectedSplitIdx());
			}
		});
		figure.setCursor(new Cursor(null, SWT.CURSOR_HAND));
		return figure;
	}

	protected void createEditPolicies() {
	}

	protected void refreshVisuals() {
		SplitModel split = (SplitModel) getModel();

		Rectangle constraint = new Rectangle(split.getX(), split.getY(),
				split.getWidth(), split.getHeight());
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}
}