/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;

public class DelGridHeaderCommand extends Command {

	private GridDef grid;

	private GridHeaderDef header;

	private int idx;

	public DelGridHeaderCommand(GridDef grid, GridHeaderDef header) {
		this.grid = grid;
		this.header = header;
	}

	public void execute() {
		idx = grid.getChildIdx(header);
		if (idx == -1) {
			throw new IllegalStateException(
					"The component is not a child of the container.");
		}
		grid.removeChild(header);
	}

	public void undo() {
		grid.addChildToIdx(header, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
