/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.swt.graphics.Image;

public class MaskatLabel extends Label {

	MaskatFigureHelper helper;

	public MaskatLabel() {
		helper = new MaskatFigureHelper(this);
	}

	public MaskatLabel(String s) {
		super(s);
		helper = new MaskatFigureHelper(this);
	}

	public MaskatLabel(Image i) {
		super(i);
		helper = new MaskatFigureHelper(this);
	}

	public MaskatLabel(String s, Image i) {
		super(s, i);
		helper = new MaskatFigureHelper(this);
	}

	/**
	 * comboItem̃}EXI𓮍Ή
	 */
	protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
		return helper.findDescendantAtExcluding(x, y, search);
	}

	/**
	 * comboItem̕\Ή߂
	 */
	protected void paintChildren(Graphics graphics) {
		super.paintChildren(graphics);

		helper.paintChildren(graphics);
	}
}
