/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.TextSerializer;
import org.exolab.castor.xml.Serializer;
import org.xml.sax.DocumentHandler;

public class MaskatSerializer implements Serializer {

	protected TextSerializer serializer;

	public MaskatSerializer() {
		serializer = new TextSerializer();
	}

	public void setOutputCharStream(Writer out) {
		serializer.setOutputCharStream(out);

	}

	public DocumentHandler asDocumentHandler() throws IOException {
		return serializer.asDocumentHandler();
	}

	public void setOutputFormat(org.exolab.castor.xml.OutputFormat format) {
		serializer.setOutputFormat((OutputFormat) format.getFormat());

	}

	public void setOutputByteStream(OutputStream output) {
		serializer.setOutputByteStream(output);

	}

}
