/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;

public class DelComponentCommand extends Command {
	private IContainerDef container;

	private IComponentDef component;

	private int idx;

	public DelComponentCommand(IContainerDef parent, IComponentDef child) {
		this.container = parent;
		this.component = child;
	}

	public void execute() {
		idx = container.getChildIdx(component);
		if (idx == -1) {
			throw new IllegalStateException(
					"The component is not a child of the container.");
		}
		container.removeChild(component);
	}

	public void undo() {
		container.addChildToIdx(component, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
