/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.maskat.framework.eventdef.Header;
import org.maskat.ide.property.descriptor.MaskatTextPropertyDescriptor;

public class HeaderProperty extends Header implements IPropertySource {

	private static final String PROP_NAME = "_prop_name_";

	private static final String PROP_VALUE = "_prop_value_";

	public HeaderProperty() {
	}

	public Object getEditableValue() {
		return this;
	}

	private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[] {
			new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
			new MaskatTextPropertyDescriptor(PROP_VALUE, "value") };

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptor;
	}

	public Object getPropertyValue(Object id) {
		if (PROP_NAME.equals(id)) {
			return getName();
		}
		if (PROP_VALUE.equals(id)) {
			return getValue();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {

	}

	public void setPropertyValue(Object id, Object value) {
		if (PROP_NAME.equals(id)) {
			setName((String) value);
		}
		if (PROP_VALUE.equals(id)) {
			setValue((String) value);
		}

	}

}