/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.requests;

import org.eclipse.gef.requests.CreationFactory;
import org.maskat.framework.screendef.ButtonDef;
import org.maskat.framework.screendef.CheckboxDef;
import org.maskat.framework.screendef.CodeLibDef;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.FrameDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.ImageDef;
import org.maskat.framework.screendef.LabelDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.framework.screendef.TextDef;
import org.maskat.framework.screendef.TreeViewDef;

public class ComponentCreateFactory implements CreationFactory {

	private Class clazz;

	public static final CreationFactory labelFactory = new ComponentCreateFactory(
			LabelDef.class);

	public static final CreationFactory textFactory = new ComponentCreateFactory(
			TextDef.class);

	public static final CreationFactory btnFactory = new ComponentCreateFactory(
			ButtonDef.class);

	public static final CreationFactory imgFactory = new ComponentCreateFactory(
			ImageDef.class);

	public static final CreationFactory codeLibFactory = new ComponentCreateFactory(
			CodeLibDef.class);

	public static final CreationFactory radioFactory = new ComponentCreateFactory(
			RadioDef.class);

	public static final CreationFactory checkboxFactory = new ComponentCreateFactory(
			CheckboxDef.class);

	public static final CreationFactory comboFactory = new ComponentCreateFactory(
			ComboDef.class);

	public static final CreationFactory frameFactory = new ComponentCreateFactory(
			FrameDef.class);

	public static final CreationFactory splitterFactory = new ComponentCreateFactory(
			SplitterDef.class);

	public static final CreationFactory tabFolderFactory = new ComponentCreateFactory(
			TabFolderDef.class);

	public static final CreationFactory tabItemFactory = new ComponentCreateFactory(
			TabItemDef.class);

	public static final CreationFactory gridFactory = new ComponentCreateFactory(
			GridDef.class);

	public static final CreationFactory gridHeaderFactory = new ComponentCreateFactory(
			GridHeaderDef.class);

	public static final CreationFactory treeFactory = new ComponentCreateFactory(
			TreeViewDef.class);

	private ComponentCreateFactory(Class clazz) {
		this.clazz = clazz;
	}

	public Object getNewObject() {
		if (clazz.equals(LabelDef.class)) {
			LabelDef labelDef = new LabelDef();
			labelDef.setName("lblNew");
			labelDef.setText("eLXgx");
			return labelDef;
		}
		if (clazz.equals(TextDef.class)) {
			TextDef textDef = new TextDef();
			textDef.setName("txtNew");
			return textDef;
		}
		if (clazz.equals(ButtonDef.class)) {
			ButtonDef buttonDef = new ButtonDef();
			buttonDef.setName("btnNew");
			buttonDef.setTitle("VK{^");
			return buttonDef;
		}
		if (clazz.equals(FrameDef.class)) {
			FrameDef frameDef = new FrameDef();
			frameDef.setName("frmNew");
			frameDef.setWidth(300);
			frameDef.setHeight(100);
			return frameDef;
		}
		if (clazz.equals(SplitterDef.class)) {
			SplitterDef splitterDef = new SplitterDef();
			splitterDef.setName("spltNew");
			splitterDef.setOrientation("h");
			splitterDef.setWidth(300);
			splitterDef.setHeight(100);
			splitterDef.setAutoResizableH("false");
			splitterDef.setAutoResizableW("false");

			DivSplitDef divSplitDef = new DivSplitDef();
			splitterDef.addChild(divSplitDef);
			divSplitDef.setName("div1");
			divSplitDef = new DivSplitDef();
			divSplitDef.setName("div2");
			splitterDef.addChild(divSplitDef);
			return splitterDef;
		}
		if (clazz.equals(TabFolderDef.class)) {
			TabFolderDef tabFolderDef = new TabFolderDef();
			tabFolderDef.setName("tbFldNew");
			tabFolderDef.setWidth(400);
			tabFolderDef.setHeight(150);
			tabFolderDef.setWidthTabName("70");

			TabItemDef tabItemDef = new TabItemDef();
			tabItemDef.setName("tabItemNew");
			tabItemDef.setTitle("VK^u");
			tabFolderDef.addChild(tabItemDef);
			return tabFolderDef;
		}
		if (clazz.equals(TabItemDef.class)) {
			TabItemDef tabItemDef = new TabItemDef();
			tabItemDef.setTitle("VK^u");
			return tabItemDef;
		}
		if (clazz.equals(GridDef.class)) {
			GridDef gridDef = new GridDef();
			gridDef.setName("grdNew");
			gridDef.setHeight(100);
			gridDef.setLineHeight("12");
			return gridDef;
		}
		if (clazz.equals(GridHeaderDef.class)) {
			GridHeaderDef gridHeaderDef = new GridHeaderDef();
			gridHeaderDef.setTitle("wb_");
			gridHeaderDef.setWidth("50");
			gridHeaderDef.setType("string");
			return gridHeaderDef;
		}
		if (clazz.equals(ImageDef.class)) {
			ImageDef imageDef = new ImageDef();
			imageDef.setName("imgNew");
			return imageDef;
		}
		if (clazz.equals(CodeLibDef.class)) {
			CodeLibDef codeLibDef = new CodeLibDef();
			codeLibDef.setName("cdlibNew");
			codeLibDef.setBoolWithLabel("true");
			codeLibDef.setWidth(120);
			return codeLibDef;
		}
		if (clazz.equals(RadioDef.class)) {
			RadioDef radioDef = new RadioDef();
			radioDef.setName("rdoNew");
			radioDef.setText("WI{bNX");
			return radioDef;
		}
		if (clazz.equals(CheckboxDef.class)) {
			CheckboxDef checkboxDef = new CheckboxDef();
			checkboxDef.setName("chkNew");
			checkboxDef.setText("`FbN{bNX");
			checkboxDef.setWidth(60);
			return checkboxDef;
		}
		if (clazz.equals(ComboDef.class)) {
			ComboDef comboDef = new ComboDef();
			comboDef.setName("cmbNew");
			comboDef.setWidth(50);
			return comboDef;
		}
		if (clazz.equals(TreeViewDef.class)) {
			TreeViewDef treeviewDef = new TreeViewDef();
			treeviewDef.setName("tvNew");
			treeviewDef.setHeight(80);
			treeviewDef.setWidth(120);
			return treeviewDef;
		}
		return null;
	}

	public Object getObjectType() {
		return clazz;
	}

}
