/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.types.BindXmlNodeType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class MappingFileSourceFactory {
    public MappingFileSourceFactory(BuilderConfiguration config) {
        if (config == null) {
            String err = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(err);
        }
    }

    public ClassMapping createMapping(ClassInfo classInfo) {
        ClassInfo base;
        boolean isAbstract;
        String nsURI;
        ClassMapping classMapping = new ClassMapping();
        JClass jClass = classInfo.getJClass();
        String className = jClass.getName();
        classMapping.setName(className);
        MapTo mapTo = new MapTo();
        classMapping.setMapTo(mapTo);
        String nsPrefix = classInfo.getNamespacePrefix();
        if (nsPrefix != null && nsPrefix.length() > 0) {
            mapTo.setNsPrefix(nsPrefix);
        }
        if ((nsURI = classInfo.getNamespaceURI()) != null && nsURI.length() > 0) {
            mapTo.setNsUri(nsURI);
        }
        mapTo.setXml(classInfo.getNodeName());
        mapTo.setElementDefinition(classInfo.isElementDefinition());
        if (classInfo.isChoice()) {
            // empty if block
        }
        if (!(isAbstract = classInfo.isAbstract())) {
            isAbstract = jClass.getModifiers().isAbstract();
        }
        classInfo.setAbstract(isAbstract);
        if (classInfo.getFieldCount() == 0) {
            return classMapping;
        }
        if (classInfo.allowContent()) {
            this.createFieldMapping(classMapping, classInfo.getTextField(), null);
        }
        if ((base = classInfo.getBaseClass()) != null) {
            classMapping.setExtends(base.getJClass().getName());
        }
        FieldInfo[] atts = classInfo.getAttributeFields();
        for (int i = 0; i < atts.length; ++i) {
            FieldInfo member = atts[i];
            if (member.isTransient() || base != null && base.getAttributeField(member.getNodeName()) != null) continue;
            this.createFieldMapping(classMapping, member, nsURI);
        }
        FieldInfo[] elements = classInfo.getElementFields();
        for (int i = 0; i < elements.length; ++i) {
            FieldInfo member = elements[i];
            if (member.isTransient() || base != null && base.getElementField(member.getNodeName()) != null) continue;
            this.createFieldMapping(classMapping, member, nsURI);
        }
        return classMapping;
    }

    private void createFieldMapping(ClassMapping classMapping, FieldInfo member, String nsURI) {
        ClassChoice classChoice;
        boolean isText;
        XSType xsType = member.getSchemaType();
        boolean any = false;
        boolean isAttribute = member.getNodeType() == 0;
        boolean bl = isText = member.getNodeType() == 2;
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.getType() == 45) {
            xsType = ((CollectionInfo)member).getContent().getSchemaType();
        }
        if ((classChoice = classMapping.getClassChoice()) == null) {
            classChoice = new ClassChoice();
        }
        FieldMapping fieldMap = new FieldMapping();
        classChoice.addFieldMapping(fieldMap);
        String fieldName = member.getName();
        if (fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        fieldMap.setName(fieldName);
        fieldMap.setType(MappingFileSourceFactory.getClassName(xsType.getJType()));
        BindXml bindXml = new BindXml();
        fieldMap.setBindXml(bindXml);
        String nodeName = member.getNodeName();
        if (nodeName != null && !isText) {
            bindXml.setName(nodeName);
        }
        if (isAttribute) {
            bindXml.setNode(BindXmlNodeType.ATTRIBUTE);
        } else if (isText) {
            bindXml.setNode(BindXmlNodeType.TEXT);
        } else {
            bindXml.setNode(BindXmlNodeType.ELEMENT);
        }
        switch (xsType.getType()) {
            case 26: {
                bindXml.setReference(true);
                break;
            }
            case 25: {
                classMapping.addIdentity(member.getName());
                break;
            }
            case 18: {
                bindXml.setType("QName");
            }
        }
        fieldMap.setHandler(member.getXMLFieldHandler());
        if (member.isContainer()) {
            fieldMap.setContainer(true);
        }
        if (member.isRequired()) {
            fieldMap.setRequired(true);
        }
        if (member.isNillable()) {
            // empty if block
        }
        if (any) {
            bindXml.setMatches("*");
        }
    }

    private static String getClassName(JType jType) {
        if (jType.isPrimitive()) {
            if (jType == JType.Int) {
                return "integer";
            }
            if (jType == JType.Double) {
                return "double";
            }
            if (jType == JType.Boolean) {
                return "boolean";
            }
        }
        return jType.toString();
    }
}

