/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.advanced;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;


public class AdvancedPropertySheetSection
	extends AbstractPropertySection {

	/**
	 * The Property Sheet Page.
	 */
	protected PropertySheetPage page;
	
	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ISection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent,
			TabbedPropertySheetPage tabbedPropertySheetPage) {
		super.createControls(parent, tabbedPropertySheetPage);
		Composite composite = getWidgetFactory()
			.createFlatFormComposite(parent);
		page = new PropertySheetPageExt();

		page.createControl(composite);
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, 0);
		data.bottom = new FormAttachment(100, 0);
		page.getControl().setLayoutData(data);
	}
	
	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ISection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
		page.selectionChanged(part, selection);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ISection#dispose()
	 */
	public void dispose() {
		super.dispose();

		if (page != null) {
			page.dispose();
			page = null;
		}

	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ISection#refresh()
	 */
	public void refresh() {
		page.refresh();
		updateActionBars();
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.ISection#shouldUseExtraSpace()
	 */
	public boolean shouldUseExtraSpace() {
		return true;
	}
	
	private void updateActionBars() {
		IActionBars actionBar = getActionBars();
		if (actionBar != null) {
			resetActionsBars(actionBar);
			page.setActionBars(actionBar);
			removeUnneededActions(actionBar);
			actionBar.updateActionBars();
		}
	}
	
	private IActionBars getActionBars() {
		try{
			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchPage wpage = workbench.getActiveWorkbenchWindow().getActivePage();
			if (wpage == null) {
				return null;
			}
			
			IViewPart vp = wpage.findView(IPageLayout.ID_PROP_SHEET); 
			if (vp == null) {
				return null;
			}
			IActionBars actionBar = vp.getViewSite().getActionBars();
			return actionBar;
		}catch(Exception e) {
		}
		return null;
	}
	
	private void removeUnneededActions(IActionBars actionBar) {
		IContributionItem[] items =  actionBar.getToolBarManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getToolBarManager().remove(items[i]);
			}
		}
		items =  actionBar.getMenuManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getMenuManager().remove(items[i]);
			}
		}
	}
	
	private void resetActionsBars(IActionBars actionBar) {
		IContributionItem[] items =  actionBar.getToolBarManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("categories".equals(items[i].getId()) || "defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getToolBarManager().remove(items[i]);
			}
		}
		items =  actionBar.getMenuManager().getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i] instanceof ActionContributionItem && 
					("categories".equals(items[i].getId()) || "defaults".equals(items[i].getId()) 
							|| "filter".equals(items[i].getId()))) {
				actionBar.getMenuManager().remove(items[i]);
			}
		}
	}
}
