/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Image;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class ImagePropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_IMAGEOUT = "_prop_imageOut_";
	
	public static final String PROP_ALTERNATETEXT = "_prop_alternateText_";
	
	public static final String PROP_BOOLFLOATLEFT = "_prop_boolFloatLeft_";
	
	public static final String PROP_BOOLFLOATRIGHT = "_prop_boolFloatRight_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_IMAGEON = "_prop_imageOn_";
	
	public static final String PROP_IMAGEDISABLED = "_prop_imageDisabled_";
	
	public static final String PROP_POSITION = "_prop_position_";

	public ImagePropertySource(Image image) {
		super(image);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_IMAGEOUT, "imageOut"),
				  new MaskatTextPropertyDescriptor(PROP_IMAGEON, "imageOn"),
//				  new MaskatTextPropertyDescriptor(PROP_IMAGEDISABLED, "imageDisabled"),
				  new MaskatTextPropertyDescriptor(PROP_ALTERNATETEXT, "alternateText")};
//				  new MaskatTextPropertyDescriptor(PROP_BOOLFLOATLEFT, "boolFloatLeft"),
//				  new MaskatTextPropertyDescriptor(PROP_BOOLFLOATRIGHT, "boolFloatRight"),
//				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION)};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_IMAGEOUT, "imageOut");
	    propMap.put(PROP_ALTERNATETEXT, "alternateText");
//	    propMap.put(PROP_BOOLFLOATLEFT, "boolFloatLeft");
//	    propMap.put(PROP_BOOLFLOATRIGHT, "boolFloatRight");
//	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_IMAGEON, "imageOn");
//	    propMap.put(PROP_IMAGEDISABLED, "imageDisabled");
//	    propMap.put(PROP_POSITION, "position");
	}
}
