/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class TabFigure extends Label {

	private String name;

	public TabFigure(String name, String title) {
		this.name = name;
		setText(title);
		setForegroundColor(ColorConstants.black);
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		setForegroundColor(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		setCursor(Cursors.HAND);
		setLayoutManager(new XYLayout());
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
