/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editpolicies;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;

import org.maskat.core.layout.Combo;
import org.maskat.core.layout.ComboItem;
import org.maskat.ui.editors.layout.commands.DelComboItemCommand;

public class ComboItemEditPolicy extends MaskatComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		ComboItem model = (ComboItem) getHost().getModel();

		return new DelComboItemCommand((Combo) model.getParent(), model);
	}
}
