/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

import org.maskat.core.layout.GridHeader;
import org.maskat.ui.Messages;

public class ChangeGridHeaderWidthCommand extends Command {
	
	private GridHeader gridHeaderDef;

	private int newWidth;
	
	private int oldWidth;

	public ChangeGridHeaderWidthCommand(GridHeader node, Rectangle newConstraint) {
		super(Messages.getString("layout.cmd.gridheader.width.msg")); //$NON-NLS-1$
		gridHeaderDef = node;
		newWidth = newConstraint.width;
		oldWidth = gridHeaderDef.getWidth();
	}

	public boolean canExecute() {
		return newWidth != oldWidth;
	}

	public void execute() {
		gridHeaderDef.setWidth(newWidth);
		super.execute();
	}

	public boolean canUndo() {
		return true;
	}

	public void undo() {
		gridHeaderDef.setWidth(oldWidth);
		super.undo();
	}
}
