/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.beanwrapper;

import org.maskat.core.event.Bind;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class SourceBind extends AbstractTreeNode {

	private static final String COLUMN_LABEL =
		Messages.getString("sourceBind.columnLabel"); //$NON-NLS-1$		

	
	public SourceBind(Bind bind) {
		super(bind);
	}

	public String getDisplayText() {
		Bind bind = (Bind)maskatElement;
		String nodeName = " - ";
		String cellIndex = " - ";

		if (bind.getNode() != null)
		{
			if  (!(bind.getNode().length() == 0))
			{
				nodeName = bind.getNode();
			}
		}
		if (bind.getFromkey() != null)
		{
			if (!(bind.getFromkey().length() == 0))
			{
				cellIndex = bind.getFromkey();
			}
		}
		
		return nodeName + " <- " + cellIndex + " " + COLUMN_LABEL;
		
	}
	
	public boolean isCopiable() {
		return true;
	}
	
	public boolean canPasteTo(ITreeNode parent) {
		return (parent != null && (parent instanceof SourceChildNode || parent instanceof SourceNode)) ? true : false;
	}

}

/*
public String getDisplayText() {

if (((Bind)maskatElement).getNode() == null || ((Bind)maskatElement).getNode().length() == 0) {
	return "<> (Column)";
}
return "<" + ((Bind)maskatElement).getNode() + "> (Column)";
}
*/
