/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.event.EventDef;
import org.maskat.core.layout.Layout;
import org.maskat.ui.editors.layout.commands.UndoableSetPropertyCommand;
import org.maskat.ui.editors.layout.tools.ComponentUtils;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class LayoutPropertySource implements IPropertySource {

	private static final String PROP_ID = "_prop_id_";

	private static final String PROP_NAME = "_prop_name_";

	private static final String PROP_REMOTEURL = "_prop_remoteurl_";

	private static final String PROP_ONLOAD = "_prop_onload_";
	
	private CommandStack commandStack;

	private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[] {
			//new MaskatTextPropertyDescriptor(PROP_ID, "id"),
			new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
			new MaskatTextPropertyDescriptor(PROP_REMOTEURL, "remoteUrl") };

	private Layout layout;

	private EventDef eventDef;
	
	public LayoutPropertySource(Layout layout) {
		this.layout = layout;
		this.eventDef = layout.getLayoutDef().getEventDef();
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptor;
	}

	public Object getPropertyValue(Object id) {
		Object result = doGetPropertyValue(id);
		return (result == null) ? "" : result;
	}

	public Object doGetPropertyValue(Object id) {
		if (PROP_ID.equals(id)) {
			return eventDef.getId();
		}
		if (PROP_REMOTEURL.equals(id)) {
			return eventDef.getRemoteUrl();
		}
		if (PROP_ONLOAD.equals(id)) {
			eventDef.findEvent("onload");
		}
		if (PROP_NAME.equals(id)) {
			return layout.getName();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if ("".equals(value)) {
			value = null;
			// PropertySourceに空白文字列を渡さないように
			// xmlに name="" のようなattributeを出力しないように
		}
		doSetPropertyValue(id, value);
	}

	public void doSetPropertyValue(Object id, Object value) {
		if (PROP_ID.equals(id)) {
			if (commandStack != null && ((value == null && eventDef.getId() != null && !"".equals(eventDef.getId()))
					|| (value != null && !value.equals(eventDef.getId())))) {
				commandStack.execute(new UndoableSetPropertyCommand(eventDef, "id", value));
				return;
			}
			eventDef.setId((String) value);
		}
		if (PROP_REMOTEURL.equals(id)) {
			if (commandStack != null && ((value == null && !"".equals(eventDef.getRemoteUrl()))
					|| (value != null && !value.equals(eventDef.getRemoteUrl())))) {
				commandStack.execute(new UndoableSetPropertyCommand(eventDef, "remoteUrl", value));
				return;
			}
			eventDef.setRemoteUrl((String) value);
		}
		if (PROP_NAME.equals(id)) {
			if(value != null && PROP_NAME.equals(id) && ComponentUtils.isExistenceId(layout, (String)value)) {
//				try {
//					value = BeanUtils.getProperty(layout, "name");
//				}catch(Exception e){
//				}
				return;
			} else if (value == null && PROP_NAME.equals(id)) {
				return;
			}
			
			if (commandStack != null && ((value == null && !"".equals(layout.getName()))
					|| (value != null && !value.equals(layout.getName())))) {
				commandStack.execute(new UndoableSetPropertyCommand(layout, "name", value));
				return;
			}
			layout.setName((String) value);
		}
	}

	public void setCommandStack(CommandStack commandStack) {
		this.commandStack = commandStack;
	}
}
