/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.CodeLib;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class CodelibPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";

	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_URL = "_prop_url_";
	
	public static final String PROP_ALWAYSREFRESH = "_prop_alwaysRefresh_";
	
	public static final String PROP_CODEWIDTH = "_prop_codeWidth_";
	
	public static final String PROP_ENABLE = "_prop_enable_";
	
	public static final String PROP_SUBMITONLOAD = "_prop_submitOnload_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";
	
	public static final String PROP_BOOLWITHLABEL = "_prop_boolWithLabel_";

	public CodelibPropertySource(CodeLib codelib) {
		super(codelib);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ENABLE, "enable"),
				  new MaskatTextPropertyDescriptor(PROP_URL, "url"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ALWAYSREFRESH, "alwaysRefresh"),
				  new MaskatTextPropertyDescriptor(PROP_CODEWIDTH, "codeWidth"),
				  new BooleanComboBoxPropertyDescriptor(PROP_SUBMITONLOAD, "submitOnload"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BOOLWITHLABEL, "boolWithLabel")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_URL, "url");
	    propMap.put(PROP_ALWAYSREFRESH, "alwaysRefresh");
	    propMap.put(PROP_CODEWIDTH, "codeWidth");
	    propMap.put(PROP_ENABLE, "enable");
	    propMap.put(PROP_SUBMITONLOAD, "submitOnload");
	    propMap.put(PROP_TABINDEX, "tabIndex");
	    propMap.put(PROP_BOOLWITHLABEL, "boolWithLabel");
	}
}
