/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.requests;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gef.requests.CreationFactory;

import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Splitter;

public class SplitterCreationFactory implements CreationFactory, IExecutableExtension {
	
	private Map properties;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.requests.CreationFactory#getNewObject()
	 */
	public Object getNewObject() {
		Splitter splitterDef = new Splitter();

		/* Populate initial values to bean */
		if (splitterDef != null && properties != null) {
			try {
				BeanUtils.populate(splitterDef, properties);
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		DivSplit divSplitDef = new DivSplit();
		divSplitDef.setName("div");
		splitterDef.addChild(divSplitDef);

		divSplitDef = new DivSplit();
		divSplitDef.setName("div1");
		splitterDef.addChild(divSplitDef);
		return splitterDef;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.requests.CreationFactory#getObjectType()
	 */
	public Object getObjectType() {
		return Splitter.class;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement,
	 *      java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName,
			Object data) throws CoreException {
		IConfigurationElement[] children = config.getChildren("property");
		if (children != null) {
			properties = new HashMap();
			for (int i = 0; i < children.length; i++) {
				String key = children[i].getAttribute("name");
				String value = children[i].getAttribute("value");
				properties.put(key, value);
			}
		}
	}

}
