/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.maskat.core.layout.StructuredComponent;

public class SplitModel {

	private int thickness;

	private StructuredComponent parent;

	private int x;
	
	private int y;
	
	private int width;
	
	private int height;

	/** モデルの状態変化を通知するリスナのリスト */
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public SplitModel(StructuredComponent parent, int thickness) {
		this.parent = parent;
		this.thickness = thickness;
	}

	public int getThickness() {
		return thickness;
	}

	public void setThickness(int thickness) {
		this.thickness = thickness;
	}

	public StructuredComponent getParent() {
		return parent;
	}

	public void setParent(StructuredComponent parent) {
		this.parent = parent;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
		firePropertyChange("constraint", "", null);
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
		firePropertyChange("constraint", "", null);
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
		firePropertyChange("constraint", "", null);
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
		firePropertyChange("constraint", "", null);
	}

	public void addPropertyChangeListener(PropertyChangeListener l) {
		listeners.addPropertyChangeListener(l);
	}

	protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener l) {
		listeners.removePropertyChangeListener(l);
	}
}
