/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.eclipse.draw2d.IFigure;

import org.maskat.core.MaskatElement;
import org.maskat.ui.editors.layout.figures.FrameFigure;

public class FrameEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {
	
	protected IFigure createFigure() {
		return new FrameFigure();
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName()) ||
			"removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getUnmodifiableChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
}
