/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.Button;
import org.maskat.ui.editors.layout.figures.ButtonFigure;

public class ButtonEditPart extends ComponentEditPart
	implements LabelDirectEditable, HorizontalResizable {

	protected IFigure createFigure() {
		return new ButtonFigure(getLabel());
	}

	protected void refreshVisuals() {
		Button comp = (Button) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		int height = d.height;
		int width = comp.isAdaptToText() ? d.width : comp.getWidth();
		
		width = (comp.getWidthMin() > width) ? comp.getWidthMin() : width;

		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				width, height);
		
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			((ButtonFigure) getFigure()).setText((String) evt.getNewValue());
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}
	
	public String getLabel() {
		return ((Button) getModel()).getTitle();
	}

	public void setLabel(String text) {
		((Button) getModel()).setTitle(text);
	}

}
