#ifndef __INC_SYM_HOUGH__
#define __INC_SYM_HOUGH__

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <vector>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

using namespace std;


class SymmetricHough{
 protected:
  IplImage *inimage,*rotimage,*bimage,*hsimage,*veimage;
  vector<unsigned char> binimage,rotregion;
  vector<int> votearray,btenarray,sedgearray;
  double pi;
  int rhostart,rhoend,rhorange,rhoskip,hsrsize,
    thetastart,thetaend,thetarange,thetaskip,hstsize,
    width,height,cx,cy,rsize,
    minrange,maxrange,
    valo;

 public:
  //SymmetricHough();
  SymmetricHough(const IplImage *img);
  ~SymmetricHough();

  void init();

  void setInImage(const IplImage *img);
  void setRegion(int nrsize);
  void setRegion(int nrsize,int ccx,int ccy);
  void setHoughSpace(int rrange,int rskip,int trange,int tskip);
  void setHoughSpace(int rstart,int rend,int rskip,int tstart,int tend,int tskip);
  void setRange(int minr,int maxr);
  void createBinImage();
  void setValidRegion(int *itable,int bw,int bh);
  void createVoteArray();
  void rotateBinImage(int theta);

  int getHSSize();

  //debug
  void *getRotateImage(int theta);
  void *getBinImage();
  void *getHoughSpaceImage();

  //convert once
  void convertOnce(int rho,int theta);
  int getValueOnce();
  vector<int> getSymmetricalEdge(){return sedgearray;}
  IplImage *getSymmetricalEdgeImage();

  void convert();
  vector<int> getResult();
  vector<int> getBest10();
};

#endif
