#include "SURFManager.h"

using namespace std;


SURFManager::SURFManager(SURFConverter *ss,
			 FeatureTracker *trk){
  surf=ss;
  track=trk;
  state=0;

  nfeatures=0;
  nfeatures_max=1000;

  reffeatures=new float[nfeatures_max*2];
  serfeatures=new float[nfeatures_max*2];
  points3d=new float[nfeatures_max*3];
  param=new float[6];

  refwidth=surf->getRefWidth();
  refheight=surf->getRefHeight();

  src_corners=new float[8];
  src_corners[0]=0;  src_corners[1]=0;
  src_corners[2]=refwidth;  src_corners[3]=0;
  src_corners[4]=refwidth;  src_corners[5]=refheight;
  src_corners[6]=0;  src_corners[7]=refheight;
  dst_corners=new float[8];
  dst_corners_mm=new float[8];

  convertTo3DPoints(4,refwidth,refheight,src_corners,
		    refwidth,refheight,points3d);

  nfeatures2=0;
  reffeatures2=new float[nfeatures_max*2];
  serfeatures2=new float[nfeatures_max*2];
  track_status0=new char[nfeatures_max];
  track_status1=new char[nfeatures_max];
  track_status_marged=new char[nfeatures_max];

  use_pca=false;
  use_lsh=false;
  use_ann=false;

  cx=320.0;
  cy=240.0;
  focal=2.8/0.006;
  dp=0.006;

  matched_num_thres=60;
}

SURFManager::~SURFManager(){
  delete reffeatures;
  delete serfeatures;
  delete reffeatures2;
  delete serfeatures2;
  delete points3d;
  delete param;
  delete src_corners;
  delete dst_corners_mm;
  delete track_status0;
  delete track_status1;
  delete track_status_marged;
}

void SURFManager::setIntrinsicParams(float f,float x,float y,float d){
  focal=f;
  cx=x;
  cy=y;
  dp=d;
}

void SURFManager::setRefImage(IplImage *img){
  surf->setRefImage(img);
  surf->convertRef();
  surf->convertPCARef();

  refwidth=surf->getRefWidth();
  refheight=surf->getRefHeight();

  src_corners[0]=0;  src_corners[1]=0;
  src_corners[2]=refwidth;  src_corners[3]=0;
  src_corners[4]=refwidth;  src_corners[5]=refheight;
  src_corners[6]=0;  src_corners[7]=refheight;

  convertTo3DPoints(4,refwidth,refheight,src_corners,
		    refwidth,refheight,points3d);
}

int SURFManager::proc(unsigned char *imgbuf){
  return proc(640,480,imgbuf);
}
int SURFManager::proc(IplImage *img){
  if(state==0){
    surf->setSerImage(img);
    surf->convertSer();
  }
  // temporary
  return procRoutine(img->width,img->height,NULL);
}
int SURFManager::proc(int width,int height,unsigned char *imgbuf){
  if(state==0){
    surf->setSerImage(width,height,imgbuf);
    surf->convertSer();
  }
  return procRoutine(width,height,imgbuf);
}

int SURFManager::procRoutine(int width,int height,unsigned char *imgbuf){
  int idx0,idx1;

  switch(state){
  case 0:
#ifdef _MSC_VER
    DWORD tt0,tt1;
    tt0=timeGetTime();
#endif
    if(use_lsh){
      surf->convertPCASer();
      nfeatures=surf->matchingPCALSH(reffeatures,serfeatures);
    }else if(use_pca){
      surf->convertPCASer();
      nfeatures=surf->matchingPCA(reffeatures,serfeatures);
    }else if(use_ann){
      nfeatures=surf->matchingANN(reffeatures,serfeatures);
    }else{
      nfeatures=surf->matching(reffeatures,serfeatures);
    }

#ifdef _MSC_VER
    tt1=timeGetTime();
    cout << "surfman->proc(): proc time: " << (tt1-tt0) << endl;
#endif
    
    cout << " nfeatures: " << nfeatures << endl;
    if(nfeatures>=matched_num_thres){
      src_corners[0]=0;  src_corners[1]=0;
      src_corners[2]=refwidth;  src_corners[3]=0;
      src_corners[4]=refwidth;  src_corners[5]=refheight;
      src_corners[6]=0;  src_corners[7]=refheight;
    
      convertTo3DPoints(4,refwidth,refheight,src_corners,
			refwidth,refheight,points3d);

      nfeatures=
       (track->getCornerCountMax()>nfeatures)?	nfeatures:track->getCornerCountMax();
      track->setImage(imgbuf);
      track->setCorners(nfeatures,serfeatures);
      if(locatePlanarObject2(nfeatures,reffeatures,serfeatures,src_corners,dst_corners)==0) return 0;
      for(int i=0;i<4;i++){
	//dst_corners_mm[i*2]=(dst_corners[i*2]-(width*0.5))*0.006;
	//dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-(height*0.5))*0.006;
	dst_corners_mm[i*2]=(dst_corners[i*2]-cx)*dp;
	dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-cy)*dp;
      }
      //FindExtrinsicCameraParams(points3d,dst_corners_mm,4,2.8,param);
      FindExtrinsicCameraParams(points3d,dst_corners_mm,4,focal*dp,param);
      nfeatures_current=nfeatures;
      reffeatures_current=reffeatures;
      serfeatures_current=serfeatures;
      state=1;

    for(int i=0;i<nfeatures;i++) track_status0[i]=1;

    }else{
      return 0;
    }
    break;
  case 1:
    track->setImage(imgbuf);
    track->track();
    track->getCornersCurrent(serfeatures);
    track->getStatus(track_status1);
    for(int i=0;i<nfeatures;i++){
      track_status_marged[i]=track_status0[i]&track_status1[i];
      track_status0[i]=track_status1[i];
    }
    nfeatures2=0;
    for(int i=0;i<nfeatures;i++){
      if(track_status_marged[i]==1){
	nfeatures2++;
	idx0=i*2;
	idx1=nfeatures2*2;
	reffeatures2[idx1]=reffeatures[idx0];
	reffeatures2[idx1+1]=reffeatures[idx0+1];
	serfeatures2[idx1]=serfeatures[idx0];
	serfeatures2[idx1+1]=serfeatures[idx0+1];
      }
    }

    cout << " nfeatures2: " << nfeatures2 << endl;
    if(nfeatures2>50){
      if(locatePlanarObject2(nfeatures2,reffeatures2,serfeatures2,src_corners,dst_corners)==0){
	state=0;
	return 0;
      }
      for(int i=0;i<4;i++){
	dst_corners_mm[i*2]=(dst_corners[i*2]-320.0)*0.006;
	dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-240.0)*0.006;
      }
      FindExtrinsicCameraParams(points3d,dst_corners_mm,4,2.8,param);
      nfeatures_current=nfeatures2;
      reffeatures_current=reffeatures2;
      serfeatures_current=serfeatures2;
    }else{
      state=0;
      return 0;
    }
    break;
  }  
  return 1;
}

int SURFManager::procList(unsigned char *imgbuf){
  return procList(640,480,imgbuf);
}
int SURFManager::procList(int width,int height,unsigned char *imgbuf){
  if(state==0) surf->setSerImage(width,height,imgbuf);
  return procListRoutine(width,height,imgbuf);
}
int SURFManager::procList(IplImage *img){
  if(state==0) surf->setSerImage(img);
  return procListRoutine(img->width,img->height,NULL);
}

int SURFManager::procListRoutine(int width,int height,unsigned char *imgbuf){
  int idx0,idx1;
  int rh,rw;
  float rhmm,rwmm;

  switch(state){
  case 0:
#ifdef _MSC_VER
    DWORD tt0,tt1;
    tt0=timeGetTime();
#endif
    surf->convertSer();
    surf->convertPCASer();

    if(use_lsh) matchedi=surf->matchingListLSH(reffeatvec,serfeatvec,matched_num_thres);
    else if(use_ann) matchedi=surf->matchingListANN(reffeatvec,serfeatvec,matched_num_thres);
    else matchedi=surf->matchingList(reffeatvec,serfeatvec,matched_num_thres);

#ifdef _MSC_VER
    tt1=timeGetTime();
    cout << "surfman->procList(): proc time: " << (tt1-tt0) << endl;
#endif
    if(matchedi!=-1){
      rw=surf->getRefWidthOf(matchedi);
      rh=surf->getRefHeightOf(matchedi);
      rwmm=surf->getRefWidthmmOf(matchedi);
      rhmm=surf->getRefHeightmmOf(matchedi);
      src_corners[0]=0;  src_corners[1]=0;
      src_corners[2]=rw;  src_corners[3]=0;
      src_corners[4]=rw;  src_corners[5]=rh;
      src_corners[6]=0;  src_corners[7]=rh;
      
      //convertTo3DPoints(4,rw,rh,src_corners,rw,rh,points3d);
      convertTo3DPoints(4,rw,rh,src_corners,rwmm,rhmm,points3d);

      nfeatures=
	(track->getCornerCountMax()>reffeatvec.size()/2)?
	reffeatvec.size()/2:track->getCornerCountMax();
      track->setImage(imgbuf);
      track->setCorners(nfeatures,&serfeatvec[0]);
      if(locatePlanarObject2(nfeatures,&reffeatvec[0],&serfeatvec[0],src_corners,dst_corners)==0)
	return -1;
      for(int i=0;i<4;i++){
	/*
	  dst_corners_mm[i*2]=(dst_corners[i*2]-(width*0.5))*0.006;
	  dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-(height*0.5))*0.006;
	*/
	dst_corners_mm[i*2]=(dst_corners[i*2]-cx)*dp;
	dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-cy)*dp;
      }
      //FindExtrinsicCameraParams(points3d,dst_corners_mm,4,2.8,param);
      FindExtrinsicCameraParams(points3d,dst_corners_mm,4,focal*dp,param);
      nfeatures_current=nfeatures;
      reffeatures_current=&reffeatvec[0];
      serfeatures_current=&serfeatvec[0];
      state=1;

      for(int i=0;i<nfeatures;i++) track_status0[i]=1;
    }else{
      return -1;
    }
    break;
  case 1:
    track->setImage(imgbuf);
    track->track();
    track->getCornersCurrent(serfeatures);
    track->getStatus(track_status1);
    for(int i=0;i<nfeatures;i++){
      track_status_marged[i]=track_status0[i]&track_status1[i];
      track_status0[i]=track_status1[i];
    }
    nfeatures2=0;
    for(int i=0;i<nfeatures;i++){
      if(track_status_marged[i]==1){
	nfeatures2++;
	idx0=i*2;
	idx1=nfeatures2*2;
	reffeatures2[idx1]=reffeatvec[idx0];
	reffeatures2[idx1+1]=reffeatvec[idx0+1];
	serfeatures2[idx1]=serfeatures[idx0];
	serfeatures2[idx1+1]=serfeatures[idx0+1];
      }
    }
    if(nfeatures2>50){
      if(locatePlanarObject2(nfeatures2,reffeatures2,serfeatures2,src_corners,dst_corners)==0){
	state=0;
	return -1;
      }
      for(int i=0;i<4;i++){
	dst_corners_mm[i*2]=(dst_corners[i*2]-320.0)*0.006;
	dst_corners_mm[i*2+1]=(dst_corners[i*2+1]-240.0)*0.006;
      }
      FindExtrinsicCameraParams(points3d,dst_corners_mm,4,2.8,param);
      nfeatures_current=nfeatures2;
      reffeatures_current=reffeatures2;
      serfeatures_current=serfeatures2;
    }else{
      state=0;
      return -1;
    }
    break;
  }
  return matchedi;
}


// for perfcheck
int SURFManager::procListEX(string &fname,int num,unsigned char *imgbuf){
  int idx0,idx1;
  int rh,rw;

#ifdef _MSC_VER
  DWORD tt0,tt1;
  tt0=timeGetTime();
#endif
  surf->setSerImage(640,480,imgbuf);
  surf->convertSer();
  surf->convertPCASer();

  matchedi=surf->matchingListLSHEX(fname,num,reffeatvec,serfeatvec);

#ifdef _MSC_VER
  tt1=timeGetTime();
  {
    ofstream ofs(fname.c_str(),ios::app);
    ofs << (tt1-tt0) << endl;
  }
#endif

  /*
  if(matchedi!=-1){    
    if(locatePlanarObject2(nfeatures,&reffeatvec[0],&serfeatvec[0],src_corners,dst_corners)==0)
      return -1;
  }
  */
  return matchedi;
}
