#include "ImageProcs.h"

float FrobeniusNorm(float *emat,int length){
  float no=0.0;
  float aa;
  for(int i=0;i<length;i++){
    aa=emat[i];
    no+=(aa*aa);
  }
  return sqrt(no);
}

int FindFundamentalMatrixRANSAC(int npoint,float *plist1,float *plist2,float* result,float thresh,unsigned char *stat){
  CvMat *pmat1,*pmat2,*fmat,*smat;
  int ret;

  pmat1=cvCreateMat(npoint,3,CV_32F);
  pmat2=cvCreateMat(npoint,3,CV_32F);
  fmat=cvCreateMat(3,3,CV_32F);
  smat=cvCreateMat(1,npoint,CV_8U);

  // convert float* to CvMat
  memcpy(pmat1->data.fl,plist1,(3*sizeof(float)*npoint));
  memcpy(pmat2->data.fl,plist2,(3*sizeof(float)*npoint));

  /*
  if(!CV_IS_MASK_ARR(smat)){
    fprintf(stderr,"CV_IS_MASK_ARR(smat) is false.\n");
    return 0;
  }else if(!CV_IS_MAT_CONT(smat->type)){
    fprintf(stderr,"CV_IS_MAT_CONT(smat->type)  is false.\n");
    return 0;
  }
  */

  //ret=cvFindFundamentalMat(pmat1,pmat2,fmat,CV_FM_8POINT,thresh,0.99,smat);
  ret=cvFindFundamentalMat(pmat1,pmat2,fmat,CV_FM_RANSAC,thresh,0.99,smat);

  // write fmat to result
  memcpy(result,fmat->data.fl,(9*sizeof(float)));

  // convert CvMat to unsigned char*
  memcpy(stat,smat->data.ptr,npoint);

  cvReleaseMat(&pmat1);
  cvReleaseMat(&pmat2);
  cvReleaseMat(&fmat);
  cvReleaseMat(&smat);

  return ret;
}

void CalcResultPair(float *emat,float *tvec0,float *rmat0,float *tvec1,float *rmat1){
  float fnorm;
  CvMat *cvemat;
  CvMat *cvumat,*cvvmat,*cvwmat;
  CvMat *cvuvt;
  float detuvt;
  CvMat *cvrmat0,*cvrmat1,*cvtmat0,*cvtmat1;
  CvMat *cvtmp0,*cvtmp1;
  CvMat *cvymat0,*cvymat1,*cvzmat0,*cvzmat1;

  cvtmp0=cvCreateMat(3,3,CV_32F);
  cvtmp1=cvCreateMat(3,3,CV_32F);

  fnorm=FrobeniusNorm(emat,9);

  cvemat=cvCreateMat(3,3,CV_32F);
  cvumat=cvCreateMat(3,3,CV_32F);
  cvvmat=cvCreateMat(3,3,CV_32F);
  cvwmat=cvCreateMat(3,3,CV_32F);

  //memcpy(cvemat->data.fl,emat,sizeof(float)*9);
  for(int i=0;i<9;i++)
    cvemat->data.fl[i]=(sqrt(2.0)*emat[i]/fnorm);

  cvSVD( cvemat, cvwmat, cvumat, cvvmat, CV_SVD_MODIFY_A | CV_SVD_V_T);
  //cvSVD( cvemat, cvwmat, cvumat, cvvmat, CV_SVD_MODIFY_A);

  cvuvt=cvCreateMat(3,3,CV_32F);
  cvMatMul(cvumat,cvvmat,cvuvt);
  detuvt=(float)cvDet(cvuvt);

  // debug
  printf("SV vector = ( ");
  for(int i=0;i<3;i++){
    printf("%f ",cvwmat->data.fl[i*3+i]);
  }
  printf(" )\n");


  cvrmat0=cvCreateMat(3,3,CV_32F);
  cvrmat1=cvCreateMat(3,3,CV_32F);
  cvtmat0=cvCreateMat(3,3,CV_32F);
  cvtmat1=cvCreateMat(3,3,CV_32F);

  cvymat0=cvCreateMat(3,3,CV_32F);
  cvymat1=cvCreateMat(3,3,CV_32F);
  cvzmat0=cvCreateMat(3,3,CV_32F);
  cvzmat1=cvCreateMat(3,3,CV_32F);
  
  cvymat0->data.fl[0]=0.0;
  cvymat0->data.fl[1]=-1.0;
  cvymat0->data.fl[2]=0.0;
  cvymat0->data.fl[3]=1.0;
  cvymat0->data.fl[4]=0.0;
  cvymat0->data.fl[5]=0.0;
  cvymat0->data.fl[6]=0.0;
  cvymat0->data.fl[7]=0.0;
  cvymat0->data.fl[8]=detuvt;

  cvymat1->data.fl[0]=0.0;
  cvymat1->data.fl[1]=1.0;
  cvymat1->data.fl[2]=0.0;
  cvymat1->data.fl[3]=-1.0;
  cvymat1->data.fl[4]=0.0;
  cvymat1->data.fl[5]=0.0;
  cvymat1->data.fl[6]=0.0;
  cvymat1->data.fl[7]=0.0;
  cvymat1->data.fl[8]=detuvt;

  cvzmat0->data.fl[0]=0.0;
  cvzmat0->data.fl[1]=1.0;
  cvzmat0->data.fl[2]=0.0;
  cvzmat0->data.fl[3]=-1.0;
  cvzmat0->data.fl[4]=0.0;
  cvzmat0->data.fl[5]=0.0;
  cvzmat0->data.fl[6]=0.0;
  cvzmat0->data.fl[7]=0.0;
  cvzmat0->data.fl[8]=0.0;

  cvzmat1->data.fl[0]=0.0;
  cvzmat1->data.fl[1]=-1.0;
  cvzmat1->data.fl[2]=0.0;
  cvzmat1->data.fl[3]=1.0;
  cvzmat1->data.fl[4]=0.0;
  cvzmat1->data.fl[5]=0.0;
  cvzmat1->data.fl[6]=0.0;
  cvzmat1->data.fl[7]=0.0;
  cvzmat1->data.fl[8]=0.0;

  // rmat0
  cvMatMul(cvumat,cvymat0,cvtmp0);
  cvMatMul(cvtmp0,cvvmat,cvrmat0);
  // rmat1
  cvMatMul(cvumat,cvymat1,cvtmp0);
  cvMatMul(cvtmp0,cvvmat,cvrmat1);

  // tmat0
  cvTranspose(cvumat,cvtmp1);
  cvMatMul(cvumat,cvzmat0,cvtmp0);
  cvMatMul(cvtmp0,cvtmp1,cvtmat0);
  // tmat1
  cvMatMul(cvumat,cvzmat1,cvtmp0);
  cvMatMul(cvtmp0,cvtmp1,cvtmat1);

  // debug
  cvMatMul(cvtmat0,cvrmat0,cvtmp0);
  cvMatMul(cvtmat1,cvrmat1,cvtmp1);

  float *mat;
  for(int i=0;i<9;i++)
    cvemat->data.fl[i]=(sqrt(2.0)*emat[i]/fnorm);
  mat=cvemat->data.fl;
  printf("emat  = |%4.3f %4.3f %4.3f|\n",mat[0],mat[1],mat[2]);
  printf("        |%4.3f %4.3f %4.3f|\n",mat[3],mat[4],mat[5]);
  printf("        |%4.3f %4.3f %4.3f|\n\n",mat[6],mat[7],mat[8]);
  mat=cvtmp0->data.fl;
  printf("emat0 = |%4.3f %4.3f %4.3f|\n",mat[0],mat[1],mat[2]);
  printf("        |%4.3f %4.3f %4.3f|\n",mat[3],mat[4],mat[5]);
  printf("        |%4.3f %4.3f %4.3f|\n\n",mat[6],mat[7],mat[8]);
  mat=cvtmp1->data.fl;
  printf("emat1 = |%4.3f %4.3f %4.3f|\n",mat[0],mat[1],mat[2]);
  printf("        |%4.3f %4.3f %4.3f|\n",mat[3],mat[4],mat[5]);
  printf("        |%4.3f %4.3f %4.3f|\n\n",mat[6],mat[7],mat[8]);

  //

  //
  memcpy(rmat0,cvrmat0->data.fl,sizeof(float)*9);
  memcpy(rmat1,cvrmat1->data.fl,sizeof(float)*9);
  
  tvec0[0]=cvtmat0->data.fl[7];
  tvec0[1]=cvtmat0->data.fl[2];
  tvec0[2]=cvtmat0->data.fl[3];

  tvec1[0]=cvtmat1->data.fl[7];
  tvec1[1]=cvtmat1->data.fl[2];
  tvec1[2]=cvtmat1->data.fl[3];

  //
  cvReleaseMat(&cvemat);
  cvReleaseMat(&cvumat);
  cvReleaseMat(&cvvmat);
  cvReleaseMat(&cvwmat);
  cvReleaseMat(&cvuvt);
  cvReleaseMat(&cvrmat0);
  cvReleaseMat(&cvrmat1);
  cvReleaseMat(&cvtmat0);
  cvReleaseMat(&cvtmat1);
  cvReleaseMat(&cvtmp0);
  cvReleaseMat(&cvtmp1);
  cvReleaseMat(&cvymat0);
  cvReleaseMat(&cvymat1);
  cvReleaseMat(&cvzmat0);
  cvReleaseMat(&cvzmat1);

}


void FindExtrinsicCameraParams(float *point3d,float *point2d,int num,float focal,float *result){
  CvMat *cvpoint3d,*cvpoint2d;
  CvMat *cvintmat;
  CvMat *cvrvec,*cvtvec;
  CvMat *dist;

  cvpoint3d=cvCreateMat(num,3,CV_32F);
  cvpoint2d=cvCreateMat(num,2,CV_32F);

  memcpy(cvpoint3d->data.fl,point3d,sizeof(float)*num*3);
  memcpy(cvpoint2d->data.fl,point2d,sizeof(float)*num*2);

  cvintmat=cvCreateMat(3,3,CV_32F);
  cvSetZero(cvintmat);
  cvintmat->data.fl[0]=focal;
  cvintmat->data.fl[4]=focal;
  cvintmat->data.fl[8]=1.0;

  cvrvec=cvCreateMat(3,1,CV_32F);
  cvtvec=cvCreateMat(3,1,CV_32F);

  dist=cvCreateMat(5,1,CV_32F);
  cvSetZero(dist);

  cvFindExtrinsicCameraParams2(cvpoint3d,cvpoint2d,cvintmat,dist,cvrvec,cvtvec);

  memcpy(result,cvtvec->data.fl,sizeof(float)*3);
  memcpy(result+3,cvrvec->data.fl,sizeof(float)*3);

  cvReleaseMat(&cvpoint3d);
  cvReleaseMat(&cvpoint2d);
  cvReleaseMat(&cvintmat);
  cvReleaseMat(&cvrvec);
  cvReleaseMat(&cvtvec);
  cvReleaseMat(&dist);
}

void FindExtrinsicCameraParamsRANSAC(float *point3d,float *point2d,int num,float focal,float *result){
  CvMat *cvpoint3d,*cvpoint2d;
  CvMat *cvintmat;
  CvMat *cvrmat,*cvrvec,*cvtvec;
  CvMat *dist;

  cvpoint3d=cvCreateMat(num,3,CV_32F);
  cvpoint2d=cvCreateMat(num,2,CV_32F);

  memcpy(cvpoint3d->data.fl,point3d,sizeof(float)*num*3);
  memcpy(cvpoint2d->data.fl,point2d,sizeof(float)*num*2);

  cvintmat=cvCreateMat(3,3,CV_32F);
  cvSetZero(cvintmat);
  cvintmat->data.fl[0]=focal;
  cvintmat->data.fl[4]=focal;
  cvintmat->data.fl[8]=1.0;

  cvrmat=cvCreateMat(3,3,CV_32F);
  cvrvec=cvCreateMat(3,1,CV_32F);
  cvtvec=cvCreateMat(3,1,CV_32F);

  dist=cvCreateMat(5,1,CV_32F);
  cvSetZero(dist);

  cvFindExtrinsicCameraParams2(cvpoint3d,cvpoint2d,cvintmat,dist,cvrvec,cvtvec);
  cvRodrigues2(cvrvec,cvrmat,NULL);

  memcpy(result,cvtvec->data.fl,sizeof(float)*3);
  memcpy(result+3,cvrvec->data.fl,sizeof(float)*3);

  cvReleaseMat(&cvpoint3d);
  cvReleaseMat(&cvpoint2d);
  cvReleaseMat(&cvintmat);
  cvReleaseMat(&cvrmat);
  cvReleaseMat(&cvrvec);
  cvReleaseMat(&cvtvec);
  cvReleaseMat(&dist);
}


int MotionStereo(int npoints,
		  float *scp0,float *scp1,
		  float *rmat,float *tvec,
		  float *result){
  float v0x,v0y,v0z,v1x,v1y,v1z,p1x,p1y,p1z;
  float s,t,norm2v0,norm2v1,ipv0v1,ipp1v0,ipp1v1,denomi;
  int i,idx;
  int zcnt=0;
  
  p1x=tvec[0];
  p1y=tvec[1];
  p1z=tvec[2];

  for(i=0;i<npoints;i++){
    idx=i*3;
    v0x=scp0[idx];
    v0y=scp0[idx+1];
    v0z=scp0[idx+2];

    v1x=scp1[idx]*rmat[0]+scp1[idx+1]*rmat[1]+scp1[idx+2]*rmat[2];
    v1y=scp1[idx]*rmat[3]+scp1[idx+1]*rmat[4]+scp1[idx+2]*rmat[5];
    v1z=scp1[idx]*rmat[6]+scp1[idx+1]*rmat[7]+scp1[idx+2]*rmat[8];

    norm2v0=(v0x*v0x+v0y*v0y+v0z*v0z);
    norm2v1=(v1x*v1x+v1y*v1y+v1z*v1z);
    ipv0v1=(v0x*v1x+v0y*v1y+v0z*v1z);
    denomi=norm2v0*norm2v1-ipv0v1*ipv0v1;

    if(fabs(denomi)<1e-8){
      result[idx]=result[idx+1]=result[idx+2]=0.0;
    }else{
      ipp1v0=(p1x*v0x+p1y*v0y+p1z*v0z);
      ipp1v1=(p1x*v1x+p1y*v1y+p1z*v1z);

      s=(norm2v1*ipp1v0-ipp1v1*ipv0v1)/denomi;
      t=(ipp1v0*ipv0v1-norm2v0*ipp1v1)/denomi;

      result[idx]=0.5*(s*v0x+p1x+t*v1x);
      result[idx+1]=0.5*(s*v0y+p1y+t*v1y);
      result[idx+2]=0.5*(s*v0z+p1z+t*v1z);

      if(s>0.0 && t>0.0){
	zcnt++;
      }
    }

  }
  return zcnt;
}
////////////////////////////////////////////////


////////////////////////

FeatureTracker::FeatureTracker(int nfeatures){
  corner_count=corner_count_max=nfeatures;

  cvgimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,1);
  cvogimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,1);
  gbuf=(unsigned char*)cvgimage->imageData;
  ogbuf=(unsigned char*)cvogimage->imageData;

  eig_img = cvCreateImage (cvSize (640,480), IPL_DEPTH_32F, 1);
  temp_img = cvCreateImage (cvSize (640,480), IPL_DEPTH_32F, 1);
  corners1 = (CvPoint2D32f *) cvAlloc (corner_count * sizeof (CvPoint2D32f));
  corners2 = (CvPoint2D32f *) cvAlloc (corner_count * sizeof (CvPoint2D32f));
  prev_pyramid = cvCreateImage (cvSize (640 + 8, 480 / 3), IPL_DEPTH_8U, 1);
  curr_pyramid = cvCreateImage (cvSize (640 + 8, 480 / 3), IPL_DEPTH_8U, 1);
  status = (char *) cvAlloc (corner_count);
  criteria = cvTermCriteria (CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, 64, 0.01);

  memset(status,0,corner_count);
}

FeatureTracker::~FeatureTracker(){

}

void FeatureTracker::setImage(unsigned char *buf){
  int i,xidx;

  memcpy(ogbuf,gbuf,640*480);
  memcpy(corners1,corners2,corner_count_max * sizeof (CvPoint2D32f));

  for(i=0;i<640*480;i++){
    xidx=i*3;
    gbuf[i]=(unsigned char)(((3*buf[xidx]+6*buf[xidx+1]+buf[xidx+2])/10));
  }
}

void FeatureTracker::select(){
  corner_count=corner_count_max;
  cvGoodFeaturesToTrack (cvgimage, eig_img, temp_img, corners2, &corner_count, 0.001, 5, NULL);
}

void FeatureTracker::track(){
  cvCalcOpticalFlowPyrLK (cvogimage, cvgimage, prev_pyramid, curr_pyramid,
			  corners1, corners2, corner_count, cvSize (10, 10), 4, status, NULL, criteria, 0);
}

void FeatureTracker::replace(){
  int pcnt,i,j;

  for(pcnt=0;pcnt<corner_count_max;pcnt++){
    if(status[pcnt]==0){

    }
  }

}

void FeatureTracker::getCornersOld(float *buf){
  int i;
  for(i=0;i<corner_count_max;i++){
    buf[2*i]=corners1[i].x;
    buf[2*i+1]=corners1[i].y;
  }
}

void FeatureTracker::getCornersCurrent(float *buf){
  int i;
  for(i=0;i<corner_count_max;i++){
    buf[2*i]=corners2[i].x;
    buf[2*i+1]=corners2[i].y;
  }
}

void FeatureTracker::getStatus(char *buf){
  memcpy(buf,status,corner_count_max);
}

void FeatureTracker::setCorners(int newcount,float *newcorners){
  int i;
  corner_count=(newcount>corner_count_max?corner_count_max:newcount);
  for(i=0;i<corner_count;i++){
    corners2[i].x=newcorners[2*i];
    corners2[i].y=newcorners[2*i+1];
    status[i]=1;
  }
  for(i=corner_count;i<corner_count_max;i++){
    status[i]=0;
  }

}

/////////////////////////////////////////////////


MonoMarkerFinder::MonoMarkerFinder(){
  cvinimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,1);
  cvoutimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,1);
  cvrgbimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,3);
  rgbbuf=(unsigned char *)cvrgbimage->imageData;

  inbuf=(unsigned char *)cvinimage->imageData;
  
  //gbuf=new unsigned char[640*480];
  gbuf=(unsigned char *)cvoutimage->imageData;
  marginx=marginy=15;
  wsize=7;
  wsizehalf=3;
  corner_count_max=32;
  corner_count=0;
  corners=new int[corner_count_max*2];

  isfound=false;

  cvogimage=cvCreateImage(cvSize(640,480),IPL_DEPTH_8U,1);
  ogbuf=(unsigned char *)cvogimage->imageData;

  eig_img = cvCreateImage (cvSize (640,480), IPL_DEPTH_32F, 1);
  temp_img = cvCreateImage (cvSize (640,480), IPL_DEPTH_32F, 1);
  corners1 = (CvPoint2D32f *) cvAlloc (corner_count_max * sizeof (CvPoint2D32f));
  corners2 = (CvPoint2D32f *) cvAlloc (corner_count_max * sizeof (CvPoint2D32f));
  prev_pyramid = cvCreateImage (cvSize (640 + 8, 480 / 3), IPL_DEPTH_8U, 1);
  curr_pyramid = cvCreateImage (cvSize (640 + 8, 480 / 3), IPL_DEPTH_8U, 1);
  status = (char *) cvAlloc (corner_count_max);
  criteria = cvTermCriteria (CV_TERMCRIT_ITER | CV_TERMCRIT_EPS, 64, 0.01);

  memset(status,0,corner_count_max);

  storage = cvCreateMemStorage (0);
}
MonoMarkerFinder::~MonoMarkerFinder(){
  //delete[] gbuf;
  cvReleaseImage(&cvinimage);
  cvReleaseImage(&cvoutimage);
  cvReleaseMemStorage(&storage);
  delete[] corners;
}

void MonoMarkerFinder::convertToMono(unsigned char *buf,unsigned char thresh){
  int i,j,xidx,idx;
  unsigned char r,g,b,pix;

  for(i=0;i<640*480;i++){
    ogbuf[i]=inbuf[i];
    idx=i*3;
    inbuf[i]=(unsigned char)(((3*buf[idx]+6*buf[idx+1]+buf[idx+2])/10));
  }

  //cvThreshold (cvinimage, cvoutimage, 0, 255, CV_THRESH_BINARY | CV_THRESH_OTSU);
  cvThreshold (cvinimage, cvoutimage, 50, 255, CV_THRESH_BINARY);
 
}

void MonoMarkerFinder::findCorner(){
  int i,j,k,l,xidx,idx,wxidx,widx;
  int bcnt;
  float bratio,pixnum;

  if(isfound){
    for(i=0;i<640*480;i++){
      idx=i*3;
      gbuf[i]=(gbuf[i]==0)?255:0;
      rgbbuf[idx]=gbuf[i];
      rgbbuf[idx+1]=gbuf[i];
      rgbbuf[idx+2]=gbuf[i];
    }

    for(i=0;i<corner_count;i++){
      corners1[i].x=corners[i*2];
      corners1[i].y=corners[i*2+1];
    }

    memset(status,0,corner_count_max);

    cvCalcOpticalFlowPyrLK (cvogimage, cvinimage, prev_pyramid, curr_pyramid,
			    corners1, corners2, corner_count, cvSize (10, 10), 4, status, NULL, criteria, 0);
    corner_count=0;
    for(i=0;i<corner_count_max;i++){
      if(status[i]==1){
	corners[i*2]=(int)(corners2[i].x+0.5);
	corners[i*2+1]=(int)(corners2[i].y+0.5);
	corner_count++;
      }
    }
  }else{

    pixnum=(float)(wsize*wsize);
    corner_count=0;

    for(i=0;i<640*480;i++)
      gbuf[i]=(gbuf[i]==0)?255:0;

    for(i=0;i<640*480;i++){
      idx=i*3;
      rgbbuf[idx]=gbuf[i];
      rgbbuf[idx+1]=gbuf[i];
      rgbbuf[idx+2]=gbuf[i];
    }

    //CvMemStorage *storage = cvCreateMemStorage (0);
    cvClearMemStorage(storage);
    CvSeq *contours = 0;

    cvFindContours (cvoutimage, storage, &contours, sizeof (CvContour), CV_RETR_CCOMP, CV_CHAIN_APPROX_SIMPLE);

    //cvDrawContours (cvrgbimage, contours, CV_RGB (255, 0, 0), CV_RGB (0, 0, 255), 2, 2, CV_AA, cvPoint (0, 0));

    // From OpenCV/samples/squares.c

    CvSeq *cont2;
    CvSeq* result;

    while(contours){
      cont2=contours->v_next;
      if(cont2){
	result = cvApproxPoly( cont2, sizeof(CvContour), storage,
			       CV_POLY_APPROX_DP, cvContourPerimeter(cont2)*0.02, 0 );
	if( result->total == 4 &&
	    fabs(cvContourArea(result,CV_WHOLE_SEQ)) > 1000 &&
	    cvCheckContourConvexity(result)
	    ){
	  for(int pcnt=0;pcnt<4;pcnt++){
	    cvLine(cvrgbimage,
		   *(CvPoint*)cvGetSeqElem(result,pcnt),
		   *(CvPoint*)cvGetSeqElem(result,(pcnt+1)%4),
		   CV_RGB(0,255,0), 3, CV_AA, 0 );
	    corners[corner_count*2]=((CvPoint*)cvGetSeqElem(result,pcnt))->x;
	    corners[corner_count*2+1]=((CvPoint*)cvGetSeqElem(result,pcnt))->y;
	    corner_count++;
	  }

	}
      }
      contours = contours->h_next;
    }
  }
  if(corner_count==4){
    isfound=true;
  }else{
    isfound=false;
  }
}

void MonoMarkerFinder::getCorners(int *buf){
  memcpy(buf,corners,sizeof(int)*corner_count*2);
}

void MonoMarkerFinder::getMonoImage(unsigned char *img){
  int i,idx;
  for(i=0;i<640*480;i++){
    idx=i*3;
    /*
    img[idx]=gbuf[i];
    img[idx+1]=gbuf[i];
    img[idx+2]=gbuf[i];
    */
    img[idx]=rgbbuf[idx];
    img[idx+1]=rgbbuf[idx+1];
    img[idx+2]=rgbbuf[idx+2];
  }
}

////////////////////////////////////

SFMManager::SFMManager(FeatureTracker *trk){
  track=trk;
  corner_count_max=track->getCornerCountMax();
  features0=new float[corner_count_max*2];
  features1=new float[corner_count_max*2];
  features2=new float[corner_count_max*2];
  track_status0=new char[corner_count_max];
  track_status1=new char[corner_count_max];
  track_status_marged=new char[corner_count_max];

  tfeatures0=new float[corner_count_max*3];
  tfeatures1=new float[corner_count_max*3];
  fund_status=new unsigned char[corner_count_max];
  fmat=new float[9];
  tvec0=new float[3];
  tvec1=new float[3];
  rmat0=new float[9];
  rmat1=new float[9];

  points3d=new float[corner_count_max*3];
  newfeatures=new float[corner_count_max*2];

  transformation=new float[16];
  markpose=new float[16];
  wmarkpose=new float[16];

  param=new float[6];
  tmppoints3d=new float[corner_count_max*3];
  tmppoints2d=new float[corner_count_max*2];

  badj=NULL;

  stat=0;
}

SFMManager::~SFMManager(){
  delete[] features0;
  delete[] features1;
  delete[] features2;
  delete[] track_status0;
  delete[] track_status1;
  delete[] track_status_marged;
  delete[] tfeatures0;
  delete[] tfeatures1;
  delete[] fund_status;
  delete[] fmat;
  delete[] tvec0;
  delete[] tvec1;
  delete[] rmat0;
  delete[] rmat1;
  delete[] points3d;
  delete[] newfeatures;
  delete[] markpose;
  delete[] wmarkpose;
  delete[] transformation;
  delete[] param;
  delete[] tmppoints3d;
  delete[] tmppoints2d;
}

void SFMManager::reset(){
  stat=0;
  corner_count=corner_count_max;
}

bool SFMManager::proc(){
  float dsum=0.0;
  int idx;
  float ox,oy,nx,ny,dx,dy;

  float normtvec0,normtvec1;

  int cnt0,cnt1,cnt2,cnt3;

  switch(stat){
  case 0:// start phase
    printf("  sfm start\n");
    track->select();
    track->getCornersCurrent(features0);
    memcpy(features2,features0,sizeof(float)*2*corner_count_max);

    corner_count=track->getCornerCount();

    for(int i=0;i<corner_count;i++)
      track_status_marged[i]=track_status0[i]=1;
    for(int i=corner_count;i<corner_count_max;i++)
      track_status_marged[i]=track_status0[i]=0;

    stat=1;
    break;
  case 1:// 2d track phase
    printf("  tracking\n");
    track->track();
    track->getCornersOld(features1);
    track->getCornersCurrent(features2);
    track->getStatus(track_status1);
    
    corner_count=0;
    //memset(track_status_marged,0,corner_count_max);
    dsum=0.0;
    for(int i=0;i<corner_count_max;i++){
      //if(track_status0[i]==1 && track_status1[i]==1){
      if(track_status_marged[i]==1 && track_status1[i]==1){
	idx=2*i;
	ox=features0[idx];
	oy=features0[idx+1];
	nx=features2[idx];
	ny=features2[idx+1];
	dx=nx-ox;
	dy=ny-oy;
	dsum+=sqrt(dx*dx+dy*dy);

	newfeatures[corner_count*2]=nx;
	newfeatures[corner_count*2+1]=ny;

	tfeatures0[corner_count*3]=(ox-160.0)*0.006;
	tfeatures0[corner_count*3+1]=(oy-120.0)*0.006;
	tfeatures0[corner_count*3+2]=2.8;
	tfeatures1[corner_count*3]=(nx-160.0)*0.006;
	tfeatures1[corner_count*3+1]=(ny-120.0)*0.006;
	tfeatures1[corner_count*3+2]=2.8;

	track_status_marged[i]=1;
	corner_count++;
      }else{
	track_status_marged[i]=0;
      }
    }

    printf(" %d corners found.",corner_count);
    if(corner_count<50){
      fprintf(stderr," tracked features are too few: %d.\n abort.\n",corner_count);
      return false;
    }

    printf("    dsum=%f\n",dsum);
    if(dsum>160.0*corner_count){
      // epa
      //if(FindFundamentalMatrixRANSAC(corner_count,tfeatures0,tfeatures1,fmat,1.0,fund_status)==0)
      if(FindFundamentalMatrixRANSAC(corner_count,tfeatures1,tfeatures0,fmat,1.0,fund_status)==0)
	return false;

      int scnt=0;
      for(int i=0;i<corner_count;i++){
	if(fund_status[i]==1){
	  tfeatures0[scnt*3]=tfeatures0[i*3];
	  tfeatures0[scnt*3+1]=tfeatures0[i*3+1];
	  tfeatures1[scnt*3]=tfeatures1[i*3];
	  tfeatures1[scnt*3+1]=tfeatures1[i*3+1];
	  newfeatures[scnt*2]=newfeatures[i*2];
	  newfeatures[scnt*2+1]=newfeatures[i*2+1];
	  scnt++;
	}
      }
      printf(" %d/%d points surivived.\n",scnt,corner_count);
      
      CalcResultPair(fmat,tvec0,rmat0,tvec1,rmat1);

      printf("tvec0 = (%f %f %f)\n",tvec0[0],tvec0[1],tvec0[2]);
      printf("tvec1 = (%f %f %f)\n\n",tvec1[0],tvec1[1],tvec1[2]);

      printf("rmat0 = |%4.3f %4.3f %4.3f|\n",rmat0[0],rmat0[1],rmat0[2]);
      printf("        |%4.3f %4.3f %4.3f|\n",rmat0[3],rmat0[4],rmat0[5]);
      printf("        |%4.3f %4.3f %4.3f|\n\n",rmat0[6],rmat0[7],rmat0[8]);

      printf("rmat1 = |%4.3f %4.3f %4.3f|\n",rmat1[0],rmat1[1],rmat1[2]);
      printf("        |%4.3f %4.3f %4.3f|\n",rmat1[3],rmat1[4],rmat1[5]);
      printf("        |%4.3f %4.3f %4.3f|\n\n",rmat1[6],rmat1[7],rmat1[8]);

      // mstereo
      normtvec0=sqrt(tvec0[0]*tvec0[0]+tvec0[1]*tvec0[1]+tvec0[2]*tvec0[2]);
      normtvec1=sqrt(tvec1[0]*tvec1[0]+tvec1[1]*tvec1[1]+tvec1[2]*tvec1[2]);
      tvec0[0]=500.0/normtvec0*tvec0[0];
      tvec0[1]=500.0/normtvec0*tvec0[1];
      tvec0[2]=500.0/normtvec0*tvec0[2];
      tvec1[0]=500.0/normtvec1*tvec1[0];
      tvec1[1]=500.0/normtvec1*tvec1[1];
      tvec1[2]=500.0/normtvec1*tvec1[2];

      if(scnt==
	 //(cnt0=MotionStereo(scnt,tfeatures0,tfeatures1,rmat0,tvec0,points3d))
	 (cnt0=MotionStereo(scnt,tfeatures1,tfeatures0,rmat0,tvec0,points3d))
	 ){
	tvec=tvec0;
	rmat=rmat0;
      }else if(scnt==
	       //(cnt1=MotionStereo(scnt,tfeatures0,tfeatures1,rmat0,tvec1,points3d))
	       (cnt1=MotionStereo(scnt,tfeatures1,tfeatures0,rmat0,tvec1,points3d))
	       ){
	tvec=tvec1;
	rmat=rmat0;
      }else if(scnt==
	       //(cnt2=MotionStereo(scnt,tfeatures0,tfeatures1,rmat1,tvec0,points3d))
	       (cnt2=MotionStereo(scnt,tfeatures1,tfeatures0,rmat1,tvec0,points3d))
	       ){
	tvec=tvec0;
	rmat=rmat1;
      }else if(scnt==
	       //(cnt3=MotionStereo(scnt,tfeatures0,tfeatures1,rmat1,tvec1,points3d))
	       (cnt3=MotionStereo(scnt,tfeatures1,tfeatures0,rmat1,tvec1,points3d))
	       ){
	tvec=tvec1;
	rmat=rmat1;
      }else{
	fprintf(stderr,"estimation failed in motion stereo.\n");
	fprintf(stderr,"%d,%d,%d,%d / %d\n",cnt0,cnt1,cnt2,cnt3,scnt);
	return false;
      }

      // 3d points
      float mx,my,mz;
      mx=my=mz=0;
      for(int i=0;i<scnt;i++){
	mx+=points3d[i*3];
	my+=points3d[i*3+1];
	mz+=points3d[i*3+2];
      }
      printf("mean of 3d points (estimated) = (%f %f %f)\n",
	     mx/scnt,my/scnt,mz/scnt);


      printf("tvec  = (%f %f %f)\n\n",tvec[0],tvec[1],tvec[2]);

      printf("rmat  = |%4.3f %4.3f %4.3f|\n",rmat[0],rmat[1],rmat[2]);
      printf("        |%4.3f %4.3f %4.3f|\n",rmat[3],rmat[4],rmat[5]);
      printf("        |%4.3f %4.3f %4.3f|\n\n",rmat[6],rmat[7],rmat[8]);
      
      // set marker pose
      SetIdentity(markpose);
      //SetEulerRotation(markpose,-PI/2,0.0,0.0);
      //SetTranslation(markpose,0.0,0.0,100.0);

      //CalcInverseTransformationByTR(tvec,rmat,transformation);
      CalcTransformationByTR(tvec,rmat,transformation);
      //SetIdentity(transformation);
      TransformMatrix(transformation,markpose,wmarkpose);

      track->setCorners(scnt,newfeatures);
      corner_count=scnt;
      stat=2;

      for(int i=0;i<corner_count;i++){
	track_status_marged[i]=track_status0[i]=1;
	features0[i*2]=newfeatures[i*2];
	features0[i*2+1]=newfeatures[i*2+1];
	features2[i*2]=newfeatures[i*2];
	features2[i*2+1]=newfeatures[i*2+1];
      }
      for(int i=corner_count;i<corner_count_max;i++)
	track_status_marged[i]=track_status0[i]=0;
      
    }
    
    break;
  case 2:// 3d track phase
    //corner_count2=0;
    corner_count=0;

    memset(track_status1,0,corner_count_max);

    track->track();
    track->getCornersOld(features1);
    track->getCornersCurrent(features2);
    track->getStatus(track_status1);

    for(int i=0;i<corner_count_max;i++){
      //if(track_status1[i]==1){
      if(track_status_marged[i]==1 && track_status1[i]==1){
	ox=features1[i*2];
	oy=features1[i*2+1];
	nx=features2[i*2];
	ny=features2[i*2+1];
	dx=nx-ox;
	dy=ny-oy;
	if(sqrt(dx*dx+dy*dy)<30.0){
	  tmppoints3d[corner_count*3]=points3d[i*3];
	  tmppoints3d[corner_count*3+1]=points3d[i*3+1];
	  tmppoints3d[corner_count*3+2]=points3d[i*3+2];
	  tmppoints2d[corner_count*2]=(features2[i*2]-320.0)*0.006;
	  tmppoints2d[corner_count*2+1]=(features2[i*2+1]-240.0)*0.006;
	  //corner_count2++;
	  corner_count++;
	}else{
	  track_status_marged[i]=0;
	}
      }else{
	track_status_marged[i]=0;
      }
    }
    if(corner_count<30){
      fprintf(stderr," tracked features are too few: %d.\n abort.\n",corner_count);
      return false;
    }

    if(badj!=NULL){
      float pfstate[6];

      badj->setPoints(tmppoints3d,tmppoints2d,corner_count);
      badj->setCameraParams(2.8);
      for(int j=0;j<3;j++){
	badj->resample();
	badj->predict();
	badj->weight();
	//badj->update(UPDATE_MAX);
	badj->update(UPDATE_MEAN);
      }
      badj->getCoords(param);
      badj->getState(pfstate);
      printf("likelihood: %f\n",badj->likelihood(pfstate));
    }else{
      FindExtrinsicCameraParams(tmppoints3d,tmppoints2d,corner_count,2.8,param);
    }

    printf("param=(%f %f %f) (%f %f %f)\n",
	   param[0],param[1],param[2],
	   param[3],param[4],param[5]);

    break;
  default:
    break;
  }
  return true;
}


