#include "HomogeneousTransformation.h"

using namespace std;

void CalcTransformationByTR(float *tvec,float *rmat,float *result){
  result[12]=result[13]=result[14]=0.0;
  result[15]=1.0;

  for(int i=0;i<3;i++){
    for(int j=0;j<3;j++){
      result[i*4+j]=rmat[i*3+j];
    }
    result[i*4+3]=tvec[i];
  }
}

void CalcInverseTransformationByTR(float *tvec,float *rmat,float *result){
  float ntvec[3];

  result[12]=result[13]=result[14]=0.0;
  result[15]=1.0;

  for(int i=0;i<3;i++){
    ntvec[i]=0.0;
    for(int j=0;j<3;j++){
      result[i*4+j]=rmat[j*3+i];
      ntvec[i]+=(-tvec[j]*rmat[j*3+i]);
    }
    result[i*4+3]=ntvec[i];
  }
}
void CalcInverseTransformationByTransformation(float *tmat,float *result){
  float rmat[9];
  float tvec[3];
  for(int i=0;i<3;i++){
    tvec[i]=tmat[i*4+3];
    for(int j=0;j<3;j++)
      rmat[i*3+j]=tmat[i*4+j];
  }
  CalcInverseTransformationByTR(tvec,rmat,result);
}
void TransformMatrix(float *tmat0,float *tmat1,float *result){
  int i,j,k;

  for(i=0;i<3;i++){
    for(j=0;j<4;j++){
      result[i*4+j]=0.0;
      for(k=0;k<3;k++){
	result[i*4+j]+=(tmat0[i*4+k]*tmat1[k*4+j]);
      }
    }
    result[i*4+3]+=tmat0[i*4+3];
    result[12+i]=0.0;
  }
  result[15]=1.0;
}

void SetIdentity(float *mat){
  for(int i=0;i<4;i++)
    for(int j=0;j<4;j++)
      mat[i*4+j]=(i==j?1.0:0.0);
}
void SetEulerRotation(float *mat,float rx,float ry,float rz){
  float cosrx,sinrx;
  float cosry,sinry;
  float cosrz,sinrz;

  cosrx=cos(rx); sinrx=sin(rx);
  cosry=cos(ry); sinry=sin(ry);
  cosrz=cos(rz); sinrz=sin(rz);

  mat[0]=cosry*cosrz;
  mat[1]=cosrz*sinrx*sinry-cosrx*sinrz;
  mat[2]=cosrx*cosrz*sinry+sinrx*sinrz;

  mat[4]=cosry*sinrz;
  mat[5]=cosrx*cosrz+sinrx*sinry*sinrz;
  mat[6]=-cosrz*sinrx+cosrx*sinry*sinrz;

  mat[8]=-sinry;
  mat[9]=cosry*sinrx;
  mat[10]=cosrx*cosry;
}
void SetRPYRotation(float *mat,float rx,float ry,float rz){
  float cosrx,sinrx;
  float cosry,sinry;
  float cosrz,sinrz;

  cosrx=cos(rx); sinrx=sin(rx);
  cosry=cos(ry); sinry=sin(ry);
  cosrz=cos(rz); sinrz=sin(rz);

  mat[0]=cosry*cosrz;
  mat[1]=-cosry*sinrz;
  mat[2]=sinry;

  mat[4]=cosrz*sinrx*sinry+cosrx*sinrz;
  mat[5]=cosrx*cosrz-sinrx*sinry*sinrz;
  mat[6]=-cosry*sinrx;

  mat[8]=-cosrx*cosrz*sinry+sinrx*sinrz;
  mat[9]=cosrz*sinrx+cosrx*sinry*sinrz;
  mat[10]=cosrx*cosry;
}
void SetTranslation(float *mat,float x,float y,float z){
  mat[3]=x;
  mat[7]=y;
  mat[11]=z;
}
void SetRotationVector(float *mat,float *rvec){
  CvMat *cvrvec,*cvrmat;
  cvrvec=cvCreateMat(3,1,CV_32F);
  cvrmat=cvCreateMat(3,3,CV_32F);
  memcpy(cvrvec->data.fl,rvec,sizeof(float)*3);
  cvRodrigues2(cvrvec,cvrmat,NULL);
  for(int i=0;i<3;i++)
    for(int j=0;j<3;j++)
      mat[i*4+j]=cvrmat->data.fl[i*3+j];
  cvReleaseMat(&cvrvec);
  cvReleaseMat(&cvrmat);
}

// quaternion
void SetQuaternionRotation(float *mat,float *quat){
  float q00,q11,q22,q33;
  float q01,q02,q03,q12,q13,q23;

  q00=quat[0]*quat[0];
  q01=quat[0]*quat[1];
  q02=quat[0]*quat[2];
  q03=quat[0]*quat[3];

  q11=quat[1]*quat[1];
  q12=quat[1]*quat[2];
  q13=quat[1]*quat[3];

  q22=quat[2]*quat[2];
  q23=quat[2]*quat[3];

  q33=quat[3]*quat[3];


  mat[0]=q00+q11-q22-q33;
  mat[1]=2.0*(q12-q03);
  mat[2]=2.0*(q13+q02);

  mat[4]=2.0*(q12+q03);
  mat[5]=q00-q11+q22-q33;
  mat[6]=2.0*(q23-q01);

  mat[8]=2.0*(q13-q02);
  mat[9]=2.0*(q23+q01);
  mat[10]=q00-q11-q22+q33;
}
void EulerToQuaternion(float rx,float ry,float rz,float *quat){
  /*
  float hrx=rx*0.5,hry=ry*0.5,hrz=rz*0.5;
  float chrx=cos(hrx),shrx=sin(hrx);
  float chry=cos(hry),shry=sin(hry);
  float chrz=cos(hrz),shrz=sin(hrz);

  quat[0]=chrx*chry*chrz - shrx*shry*shrz;
  quat[1]=shrx*chry*chrz + chrx*shry*shrz;
  quat[2]=chrx*shry*chrz - shrx*chry*shrz;
  quat[3]=chrx*chry*shrz + shrx*shry*chrz;
  */
  float tmat[16];
  SetIdentity(tmat);
  SetEulerRotation(tmat,rx,ry,rz);
  ExtractQuaternion(tmat,quat);
}
void RPYToQuaternion(float rx,float ry,float rz,float *quat){
  float tmat[16];
  SetIdentity(tmat);
  SetRPYRotation(tmat,rx,ry,rz);
  ExtractQuaternion(tmat,quat);
}
void QuaternionCross(float *quat1,float *quat2,float *result){
  result[0] = quat1[0]*quat2[0] - quat1[1]*quat2[1] - quat1[2]*quat2[2] - quat1[3]*quat2[3];
  result[1] = quat1[0]*quat2[1] + quat1[1]*quat2[0] + quat1[2]*quat2[3] - quat1[3]*quat2[2];
  result[2] = quat1[0]*quat2[2] + quat1[2]*quat2[0] + quat1[3]*quat2[1] - quat1[1]*quat2[3];
  result[3] = quat1[0]*quat2[3] + quat1[3]*quat2[0] + quat1[1]*quat2[2] - quat1[2]*quat2[1];
}
void RotateQuaternion(float *quat1,float *quat2,float *result){
  float mquat2[4],quat3[4];
  for(int i=0;i<4;i++) mquat2[i]=-quat2[i];
  QuaternionCross(mquat2,quat1,quat3);
  QuaternionCross(quat3,quat2,result);
}
void ExtractQuaternion(float *tmat,float *quat){
  /*
    |  0   1   2   3 |
    |  4   5   6   7 |
    |  8   9  10  11 |
    | 12  13  14  15 |
  */


  float ww,xx,yy,zz;
  ww=tmat[0]+tmat[5]+tmat[10];
  xx=tmat[0]-tmat[5]-tmat[10];
  yy=-tmat[0]+tmat[5]-tmat[10];
  zz=-tmat[0]-tmat[5]+tmat[10];

  float maxv=ww;
  int idx=0;

  if(xx>maxv){
    maxv=xx;
    idx=1;
  }
  if(yy>maxv){
    maxv=yy;
    idx=2;
  }
  if(zz>maxv){
    maxv=zz;
    idx=3;
  }

  float val=0.5*(sqrt(maxv+1.0));
  float mult=0.25/val;
  
  switch(idx){
  case 0:
    quat[0]=val;
    quat[1]=(tmat[6]-tmat[9])*mult;
    quat[2]=(tmat[8]-tmat[2])*mult;
    quat[3]=(tmat[1]-tmat[4])*mult;
    break;
  case 1:
    quat[0]=(tmat[6]-tmat[9])*mult;
    quat[1]=val;
    quat[2]=(tmat[1]+tmat[4])*mult;
    quat[3]=(tmat[8]+tmat[2])*mult;
    break;
  case 2:
    quat[0]=(tmat[8]-tmat[2])*mult;
    quat[1]=(tmat[1]+tmat[4])*mult;
    quat[2]=val;
    quat[1]=(tmat[6]+tmat[9])*mult;
    break;
  case 3:
    quat[0]=(tmat[1]-tmat[4])*mult;
    quat[1]=(tmat[8]+tmat[2])*mult;
    quat[2]=(tmat[6]+tmat[9])*mult;
    quat[3]=val;
    break;
  }


}


void SlerpQuaternion(float *quat1,float *quat2,float tt,float *result){
  float w0,x0,y0,z0;
  float w1,x1,y1,z1;
  float coso,sino;
  float k0,k1;
  float omg;
  float rr;

  w0=quat1[0]; x0=quat1[1]; y0=quat1[2]; z0=quat1[3];
  w1=quat2[0]; x1=quat2[1]; y1=quat2[2]; z1=quat2[3];

  coso=w0*w1+x0*x1+y0*y1+z0*z1;
  if(coso<0.0){
    w1=-w1; x1=-x1; y1=-y1; z1=-z1;
    coso=-coso;
  }
  if(coso>0.9999){
    k0=1.0-tt;
    k1=tt;
  }else{
    sino=sqrt(1.0-coso*coso);
    omg=atan2(sino,coso);
    rr=1.0/sino;

    k0=sin((1.0-tt)*omg)*rr;
    k1=sin(tt*omg)*rr;
  }
  result[0]=k0*w0+k1*w1;
  result[1]=k0*x0+k1*x1;
  result[2]=k0*y0+k1*y1;
  result[3]=k0*z0+k1*z1;
}

void QuaternionToAxisAngle(float *quat,float *aa){
  float tt,st,nx,ny,nz;
  tt=acos(quat[0]); // tt = theta/2;
  st=sin(tt);
  if(fabs(st)>1e-8){
    nx=quat[0]/st;
    ny=quat[1]/st;
    nz=quat[2]/st;

    aa[0]=nx*tt*2.0;
    aa[1]=ny*tt*2.0;
    aa[2]=nz*tt*2.0;
  }else{
    aa[0]=0.0;
    aa[1]=0.0;
    aa[2]=0.0;
  }
}
void AxisAngleToQuaternion(float *aa,float *quat){
  float theta,ct,st,nx,ny,nz;
  theta=sqrt(aa[0]*aa[0]+aa[1]*aa[1]+aa[2]*aa[2]);
  if(fabs(theta)>1e-8){
    nx=aa[0]/theta;
    ny=aa[1]/theta;
    nz=aa[2]/theta;

    ct=cos(theta*0.5);
    st=sin(theta*0.5);
    quat[0]=ct;
    quat[1]=nx*st;
    quat[2]=ny*st;
    quat[3]=nz*st;
  }else{
    quat[0]=1.0;
    quat[1]=0.0;
    quat[2]=0.0;
    quat[3]=0.0;
  }
}

void TransformVector(float *vec,float *tmat,float *result){
  result[0]=vec[0]*tmat[0]+vec[1]*tmat[1]+vec[2]*tmat[2]+tmat[3];
  result[1]=vec[0]*tmat[4]+vec[1]*tmat[5]+vec[2]*tmat[6]+tmat[7];
  result[2]=vec[0]*tmat[8]+vec[1]*tmat[9]+vec[2]*tmat[10]+tmat[11];
}

void RotateVector(float *vec,float *tmat,float *result){
  result[0]=vec[0]*tmat[0]+vec[1]*tmat[1]+vec[2]*tmat[2];
  result[1]=vec[0]*tmat[4]+vec[1]*tmat[5]+vec[2]*tmat[6];
  result[2]=vec[0]*tmat[8]+vec[1]*tmat[9]+vec[2]*tmat[10];
}
