#ifndef __HYPARTICLEFILTER_H__
#define __HYPARTICLEFILTER_H__

#define UPDATE_MEAN 0x0
#define UPDATE_MAX 0x1

class HYParticleFilter{
 private:

 public:
  int dstate;
  int nparticles;
  float *state;
  float *stateTable;
  float *ostateTable;
  float *weightTable;
  float resampleRange,hresampleRange;

  HYParticleFilter(int ds,int np,float rr);
  ~HYParticleFilter();

  void initParticles();

  // main routine
  void resample();
  virtual void predict(){/* nop */}
  void weight();
  void update(int method);

  void update_max();
  void update_mean();

  // sub routine
  void normalizeWeight();
  virtual float likelihood(float *state){return 1.0;}

  // getter
  void getState(float *st){
    memcpy(st,state,(sizeof(float)*dstate));
  }
  void getStateTable(float *st){
    memcpy(st,stateTable,(sizeof(float)*dstate*nparticles));
  }
  void getWeightTable(float *wt){
    memcpy(wt,weightTable,(sizeof(float)*dstate*nparticles));
  }

  // setter/getter
  void setResampleRange(float rr){
    resampleRange=rr;
    hresampleRange=resampleRange*0.5;
  }
  float getResampleRange(){return resampleRange;}

};


#endif
