#ifndef __GTKTEXTVIEW_H__
#define __GTKTEXTVIEW_H__

#include "GtkCtrl.h"

using namespace std;

// http://ilaliart.sourceforge.jp/tips/gtk_jp2.html

class GtkTextViewer{
 private:
 GtkWidget *window;
 GtkWidget *scrolledwindow;
 GtkWidget *textview;

 public:
  GtkTextViewer();
  ~GtkTextViewer();

  void show();
  void clearString();
  void addString(string &str);
  void addString(const char *cbuf,int length);
  void addChar(const char *cbuf);
};


// http://homepage2.nifty.com/well/Stream.html
class GTstreambuf : public streambuf {
  char m_acBuffer[2]; // o͗p̈ꎞobt@
  GtkTextViewer *gtext;
 public:
  GTstreambuf(GtkTextViewer *gt){
    //ZeroMemory(m_acBuffer, sizeof m_acBuffer);     // obt@NAĂB
    memset(m_acBuffer, 0, sizeof m_acBuffer);
    gtext=gt;
  }

  virtual streamsize xsputn( const char * s, streamsize n ){
    gtext->addString(s,(int)n);
    return n;
  }

  virtual int_type overflow(int_type iChar = EOF) {
    if (iChar != EOF) {
      m_acBuffer[0] = iChar;          // obt@ɏŁA
      //OutputDebugString(m_acBuffer);  // foOɏo͂B
      gtext->addChar(m_acBuffer);
    }
    return iChar;   // o͂Ƃɂ EOF ȊOԂB
  }
};

class GTout : public ostream {
  GTstreambuf* m_pdstreambuf;
 public:
  ~GTout() { delete m_pdstreambuf; }
  GTout(GtkTextViewer *gt) : ostream(m_pdstreambuf = new GTstreambuf(gt)) {}
};



#endif
