#include "DSCapture.h"


IPin *GetPin(IBaseFilter *pFilter, PIN_DIRECTION PinDir)
{
  BOOL       bFound = FALSE;
  IEnumPins  *pEnum;
  IPin       *pPin;

  pFilter->EnumPins(&pEnum);
  while(pEnum->Next(1, &pPin, 0) == S_OK)
    {
      PIN_DIRECTION PinDirThis;
      pPin->QueryDirection(&PinDirThis);
      if (bFound = (PinDir == PinDirThis)) // Ŏw肵̃sȂbreak
        break;
      pPin->Release();
    }
  pEnum->Release();
  return (bFound ? pPin : 0);
}


STDMETHODIMP CGrabCB::BufferCB(double SampleTime, BYTE *pBuffer, long BufferLen)
{
  int i,j,xidx0,idx0,xidx1,idx1;
  /*
    cerr << "Index:" << cnt << "\t";
    cerr << "Sample time: " << SampleTime  << "\t";
    cerr << "BufferLen: " << BufferLen;
    cerr << endl;
    cnt++;
   */
  ResetEvent(*wevent);
  WaitForSingleObject(*cpflag,INFINITE);

  switch(BufferLen){
  case 640*480*3:
    for(i=0;i<480;i++){
      xidx0=640*i;
      xidx1=640*(479-i);
      for(j=0;j<640;j++){
	idx0=(xidx0+j)*3;
	idx1=(xidx1+j)*3;
	imgbuf[idx0]=pBuffer[idx1+2];
	imgbuf[idx0+1]=pBuffer[idx1+1];
	imgbuf[idx0+2]=pBuffer[idx1];
      }
    }
    break;
  case 320*240*3:
    for(i=0;i<240;i++){
      xidx0=640*i;
      xidx1=320*(239-i);
      for(j=0;j<320;j++){
	idx0=(xidx0+j)*3;
	idx1=(xidx1+j)*3;
	imgbuf[idx0]=pBuffer[idx1+2];
	imgbuf[idx0+1]=pBuffer[idx1+1];
	imgbuf[idx0+2]=pBuffer[idx1];
      }
    }
    break;
  default:
    break;
  }
  (*cnt)++;

  SetEvent(*cpflag);
  SetEvent(*wevent);
  return S_OK;
}
  // RXgN^
CGrabCB::CGrabCB(HANDLE *wev,HANDLE *cpf,int *fcnt,unsigned char *buf) : CUnknown("SGCB", NULL){
  cnt=fcnt;
  imgbuf=buf;
  wevent=wev;
  cpflag=cpf;
  SetEvent(*cpflag);
}


DSCapture::DSCapture(){
  pGraph=NULL;
  pDevEnum=NULL;
  pClassEnum=NULL;
  pMoniker=NULL;
  pSrc=NULL;
  pBuilder=NULL;
  pF=NULL;
  pSGrab=NULL;
  pSrcOut=NULL;
  pSGrabIN=NULL;
  pSGrabOut=NULL;
  cb=NULL;
  pMediaControl=NULL;
  pEvent=NULL;

  wevent=CreateEvent(NULL, FALSE, FALSE, NULL);
  cpflag=CreateEvent(NULL, FALSE, FALSE, NULL);

  width=640;
  height=480;
  sampletime=333333;
  image=new unsigned char[width*height*3];
  ZeroMemory(image, width*height*3);
  framecount=0;

  
  cout << "Initialize COM" << endl;
  CoInitialize(NULL);
  
  cout << "1." << endl;
  // 1. tB^Ot쐬
  CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,
      IID_IGraphBuilder, (void **)&pGraph);

  cout << "2." << endl;
  // 2. VXefoCX񋓎q쐬
  CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC,
      IID_ICreateDevEnum, (void **)&pDevEnum);

  pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pClassEnum, 0);

  if(pClassEnum==NULL){
    MessageBox(NULL, L"error: No capture device found.", L"DSCapture", MB_OK);
    exit(0);
  }

  // select device
  TCHAR *devname;
  devnames.clear();

  while (pClassEnum->Next(1, &pMoniker, &cFetched) == S_OK){
    // get the device friendly name:
    IPropertyBag *pPropertyBag;
    devname=new TCHAR[128];

    // IPropertyBagbind
    pMoniker->BindToStorage(0, 0, IID_IPropertyBag,
			    (void **)&pPropertyBag);

    // Friendly name擾邽߂̓ꕨ
    VARIANT varFriendlyName;
    varFriendlyName.vt = VT_BSTR;
   
    // FriendlyName擾
    pPropertyBag->Read(L"FriendlyName", &varFriendlyName, 0);

    // 擾FriendlyNameRs[
#ifdef UNICODE
    // ÔUNICODE̎̃R[h
    _tcscpy(devname, varFriendlyName.bstrVal);
#else
    // ɉȂ΁AUNICODEł͂ȂAɂȂ͂ł
    WideCharToMultiByte(CP_ACP, 0,
			varFriendlyName.bstrVal, -1, devname, sizeof(devname), 0, 0);
#endif      

    // ʂ\
    //MessageBox(NULL, devname, L"DEVICE NAME", MB_OK);
    devnames.push_back(devname);

    // 
    VariantClear(&varFriendlyName);

    // 
    pMoniker->Release();
    pPropertyBag->Release();

  }
  //
}

void DSCapture::open(int dev){
  pClassEnum->Reset();
  pClassEnum->Skip(dev);
  if (pClassEnum->Next(1, &pMoniker, &cFetched) == S_OK){
    // ŏ̃jJtB^IuWFNgɃoCh
    pMoniker->BindToObject(0, 0, IID_IBaseFilter, (void **)&pSrc);
    pMoniker->Release();
  }
  pClassEnum->Release();
  pDevEnum->Release();

  pGraph->AddFilter(pSrc, L"Video Capture");

  cout << "3." << endl;
  // 3. Lv`r_̍쐬
  CoCreateInstance(CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC,
      IID_ICaptureGraphBuilder2, (void **)&pBuilder);
  pBuilder->SetFiltergraph(pGraph);

  
  //from http://d.hatena.ne.jp/xabre/20050714
  //IAMStreamConfigC^[tF[X
  IAMStreamConfig *pConfig = NULL;
  //pSrc̓Lv`foCX̃tB^@Lv`JeS̃s pBuilderICaptureBuilder2
  hr = pBuilder->FindInterface(&PIN_CATEGORY_CAPTURE ,0,pSrc,IID_IAMStreamConfig,(void**)&pConfig);
  if(FAILED(hr)){
    //cout << "error: pBuilder->FindInterface" << endl;
    MessageBox(NULL, L"error: pBuilder->FindInterface", L"DSCapture", MB_OK);
    exit(0);
  }
  int iCount = 0, iSize = 0;
  AM_MEDIA_TYPE *namt=NULL;
  hr = pConfig->GetNumberOfCapabilities(&iCount, &iSize);
  // TCY𒲂ׁA\̂nƂmFB
  if (iSize == sizeof(VIDEO_STREAM_CONFIG_CAPS)){
    // rfI\͍\̂gB
    for (int iFormat = 0; iFormat < iCount; iFormat++){
      VIDEO_STREAM_CONFIG_CAPS scc;
      AM_MEDIA_TYPE *pmtConfig;
      hr = pConfig->GetStreamCaps(iFormat, &pmtConfig, (BYTE*)&scc);
      VIDEOINFOHEADER *pVih2;
      if (SUCCEEDED(hr)){
	if ((pmtConfig->formattype == FORMAT_VideoInfo) && 
	    (pmtConfig->cbFormat >= sizeof(VIDEOINFOHEADER)) &&
	    (pmtConfig->pbFormat != NULL)){
	  //VIDEOINFOHEADERpVih2IAMStreamConfigpbFormat
	  pVih2 = (VIDEOINFOHEADER*)pmtConfig->pbFormat;
	  
	  if((pVih2->bmiHeader.biWidth == width) &&
	     (pVih2->bmiHeader.biHeight == height)
/*
	     &&
	     (pVih2->AvgTimePerFrame >= (sampletime-10000)) &&
	     (pVih2->AvgTimePerFrame <= (sampletime+10000))
*/
	     ){
	    namt=pmtConfig;
      //((VIDEOINFOHEADER*)(namt->pbFormat))->AvgTimePerFrame = 0;
      ((VIDEOINFOHEADER*)(namt->pbFormat))->AvgTimePerFrame = 333333;
	    break;
	  }
	}
      }
    }
  }
  if(namt==NULL){
    //cout << "warning: format not found" << endl;
    MessageBox(NULL, L"failed: format not found", L"DSCapture", MB_OK);
    exit(0);
  }else{
    hr=pConfig->SetFormat(namt);
    if(FAILED(hr)){
      //cout << "failed : pConfig->SetFormat" << endl;
      MessageBox(NULL, L"failed : pConfig->SetFormat", L"DSCapture", MB_OK);
      exit(0);
    }
  }
  //
  

  cout << "4." << endl;
  // 4. ꖇB
  cout << "4-1." << endl;
  // 4-1. TvOo̐
  CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER,
      IID_IBaseFilter, (LPVOID *)&pF);
  pF->QueryInterface(IID_ISampleGrabber, (void **)&pSGrab);

  cout << "4-2." << endl;
  // 4-2. fBA^Cv̐ݒ
  ZeroMemory(&mt, sizeof(AM_MEDIA_TYPE));
  mt.majortype = MEDIATYPE_Video; // Sample Grabber ̓̓s(Capture Device ̏o̓s)UYVY
  //mt.subtype = MEDIASUBTYPE_UYVY;     
  mt.subtype = MEDIASUBTYPE_RGB24;     
  mt.formattype = FORMAT_VideoInfo;
  pSGrab->SetMediaType(&mt);

  cout << "4-3." << endl;
  // 4-3. tB^Ot֒ǉ
  pGraph->AddFilter(pF, L"Grabber");

  cout << "4-4." << endl;
  // 4-4. TvOo̐ڑ
  // [pSrc](o) -> (i)[pF](o) -> [VideoRender]
  //        A   B     C
  pSrcOut = GetPin(pSrc, PINDIR_OUTPUT);  // A
  pSGrabIN = GetPin(pF, PINDIR_INPUT);    // B
  pSGrabOut = GetPin(pF, PINDIR_OUTPUT);  // C

  pGraph->Connect(pSrcOut, pSGrabIN);
  pGraph->Render(pSGrabOut);

  cout << "4-5." << endl;
  // 4-5. Oõ[hK؂ɐݒ
  pSGrab->SetBufferSamples(FALSE);
  pSGrab->SetOneShot(FALSE);
  cout << "4-5-1." << endl;
  cb = new CGrabCB(&wevent,&cpflag,&framecount,image);
  cout << "4-5-2." << endl;
  pSGrab->SetCallback(cb, 1);  // 2ŃR[obNw (0:SampleCB, 1:BufferCB)

  pGraph->QueryInterface(IID_IMediaControl, (void **)&pMediaControl);
  pGraph->QueryInterface(IID_IMediaEvent, (void **)&pEvent);
}

DSCapture::~DSCapture(){
  // 6. I
  pF->Release();      // 
  pSGrab->Release();  // 킷ꂸɉ
  pSrc->Release();
  pMediaControl->Release();
  pBuilder->Release();
  pGraph->Release();
  delete cb;
  delete[] image;
  CoUninitialize();
}

void DSCapture::start(){
  pMediaControl->Run();
  for(int ccc=0;ccc<100;ccc++){
    if(framecount!=0) break;
    else Sleep(100);
  }
}

void DSCapture::stop(){
  SetEvent(cpflag);
  SetEvent(wevent);
  pEvent->WaitForCompletion(100, &evCode);
  pMediaControl->Stop();
}

void DSCapture::wait(){
  WaitForSingleObject(wevent,INFINITE);
}

void DSCapture::getBuffer(int *cnt,unsigned char *buf){
  WaitForSingleObject(cpflag,INFINITE);
  *cnt=framecount;
  memcpy(buf,image,width*height*3);
  SetEvent(cpflag);
}


void DSCapture::getDeviceName(int idx,char *str){
    //MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,(LPCSTR)devnames[idx], -1, (LPWSTR)str, sizeof(str));
    //memcpy(str,devnames[idx],128*sizeof(TCHAR));
  for(int i=0;i<127;i++){
    TCHAR ch=devnames[idx][i];
    str[i]=(ch>0x80)?'?':ch;
  }
  str[128]='\0';
}
